/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aispeech.realtimespeech;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.oracle.bmc.aispeech.model.RealtimeMessage;
import com.oracle.bmc.aispeech.model.RealtimeMessageAckAudio;
import com.oracle.bmc.aispeech.model.RealtimeMessageAuthenticationCredentials;
import com.oracle.bmc.aispeech.model.RealtimeMessageConnect;
import com.oracle.bmc.aispeech.model.RealtimeMessageError;
import com.oracle.bmc.aispeech.model.RealtimeMessageResult;
import com.oracle.bmc.aispeech.model.RealtimeMessageSendFinalResult;
import com.oracle.bmc.aispeech.model.RealtimeParameters;
import com.oracle.bmc.aispeech.realtimespeech.RealtimeSpeechClientListener;
import com.oracle.bmc.aispeech.realtimespeech.RealtimeSpeechConnectException;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.http.signing.DefaultRequestSigner;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.serialization.jackson.JacksonSerializer;
import com.oracle.bmc.util.VisibleForTesting;
import com.oracle.bmc.util.internal.StringUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class RealtimeSpeechClient {
    private final String compartmentId;
    private WebSocketClient webSocketClient;
    private Session session;
    private boolean isConnected = false;
    private RealtimeSpeechClientListener listener;
    private BasicAuthenticationDetailsProvider authenticationDetailsProvider;
    private URI destUri;
    private Boolean isClosureClientInitiated = false;
    private Status status;
    private static final Logger LOG = LoggerFactory.getLogger(RealtimeSpeechClient.class);
    private final FilterProvider filters = new SimpleFilterProvider().setFailOnUnknownId(false).addFilter("explicitlySetFilter", SimpleBeanPropertyFilter.serializeAll());
    private final ObjectMapper objectMapper = JacksonSerializer.getDefaultObjectMapper().setFilterProvider(this.filters);

    public RealtimeSpeechClient(RealtimeSpeechClientListener listener, BasicAuthenticationDetailsProvider authenticationDetailsProvider, String compartmentId, WebSocketClient webSocketClient) {
        this.listener = listener;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        this.compartmentId = compartmentId;
        this.webSocketClient = webSocketClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        LOG.info("Session closed by {} : reason = {}, status code = {}", new Object[]{this.isClosureClientInitiated != false ? "client" : "server", reason, statusCode});
        this.isConnected = false;
        this.status = Status.DISCONNECTED;
        this.listener.onClose(statusCode, reason);
        this.session = null;
        this.webSocketClient = null;
        this.listener = null;
    }

    @OnWebSocketError
    public void onError(Throwable error) {
        LOG.info("Error: {}", (Object)error.getMessage());
        this.isConnected = false;
        this.session = null;
        this.status = Status.ERROR;
        if (this.listener != null) {
            this.listener.onError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketConnect
    public void onConnect(Session session) {
        LOG.info("Connect: {}", (Object)session.getRemoteAddress().getAddress());
        RealtimeSpeechClient realtimeSpeechClient = this;
        synchronized (realtimeSpeechClient) {
            this.session = session;
        }
        this.sendCreds(this.compartmentId);
        this.status = Status.CONNECTED;
        this.isConnected = true;
        if (this.listener != null) {
            this.listener.onConnect();
        }
    }

    @OnWebSocketMessage
    public void onMessage(String message) throws JsonProcessingException {
        if (this.listener == null) {
            return;
        }
        try {
            RealtimeMessage realtimeMessage = (RealtimeMessage)this.objectMapper.readValue(message, RealtimeMessage.class);
            if (realtimeMessage instanceof RealtimeMessageAckAudio) {
                this.listener.onAckMessage((RealtimeMessageAckAudio)realtimeMessage);
            } else if (realtimeMessage instanceof RealtimeMessageConnect) {
                this.listener.onConnectMessage((RealtimeMessageConnect)realtimeMessage);
            } else if (realtimeMessage instanceof RealtimeMessageResult) {
                this.listener.onResult((RealtimeMessageResult)realtimeMessage);
            } else if (realtimeMessage instanceof RealtimeMessageError) {
                RealtimeMessageError errorMessage = (RealtimeMessageError)realtimeMessage;
                LOG.error("Received RealtimeMessageError with message {}", (Object)errorMessage.getMessage());
                this.listener.onError(new ConnectException(errorMessage.getMessage()));
            }
        }
        catch (JsonProcessingException e) {
            LOG.error("Text Message: JsonProcessingException {}", (Throwable)e);
        }
    }

    public void open(String realtimeSpeechEndpoint, RealtimeParameters parameters) throws RealtimeSpeechConnectException {
        try {
            this.status = Status.CONNECTING;
            String customizationsJson = this.objectMapper.writeValueAsString((Object)parameters.getCustomizations());
            String queryParameter = "";
            if (parameters.getIsAckEnabled() != null) {
                queryParameter = queryParameter + "isAckEnabled=" + (parameters.getIsAckEnabled() != false ? "true" : "false") + "&";
            }
            if (parameters.getShouldIgnoreInvalidCustomizations() != null) {
                queryParameter = queryParameter + "shouldIgnoreInvalidCustomizations=" + (parameters.getShouldIgnoreInvalidCustomizations() != false ? "true" : "false") + "&";
            }
            if (parameters.getPartialSilenceThresholdInMs() != null) {
                queryParameter = queryParameter + "partialSilenceThresholdInMs=" + parameters.getPartialSilenceThresholdInMs() + "&";
            }
            if (parameters.getFinalSilenceThresholdInMs() != null) {
                queryParameter = queryParameter + "finalSilenceThresholdInMs=" + parameters.getFinalSilenceThresholdInMs() + "&";
            }
            if (parameters.getStabilizePartialResults() != null) {
                queryParameter = queryParameter + "stabilizePartialResults=" + parameters.getStabilizePartialResults().getValue() + "&";
            }
            if (parameters.getLanguageCode() != null) {
                queryParameter = queryParameter + "languageCode=" + parameters.getLanguageCode() + "&";
            }
            if (parameters.getModelDomain() != null) {
                queryParameter = queryParameter + "modelDomain=" + parameters.getModelDomain().getValue() + "&";
            }
            if (parameters.getCustomizations() != null && !parameters.getCustomizations().isEmpty()) {
                queryParameter = queryParameter + "customizations=" + URLEncoder.encode(customizationsJson, "UTF-8");
            }
            if (queryParameter.length() > 0 && queryParameter.charAt(queryParameter.length() - 1) == '&') {
                queryParameter = queryParameter.substring(0, queryParameter.length() - 1);
            }
            this.destUri = new URI(realtimeSpeechEndpoint + "/ws/transcribe/stream?" + queryParameter);
            LOG.info("Connecting to {} \n", (Object)this.destUri);
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            LOG.info("Content-Type: {}", (Object)parameters.getEncoding());
            request.setHeader("Content-Type", parameters.getEncoding());
            if (!this.webSocketClient.isStarted()) {
                LOG.info("Client not started, starting it now");
                this.webSocketClient.start();
            }
            this.session = (Session)this.webSocketClient.connect((Object)this, this.destUri, request).get(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.status = Status.ERROR;
            LOG.error("Open connection exception {}", (Throwable)e);
            throw new RealtimeSpeechConnectException(e);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void sendAudioData(byte[] audioBytes) throws RealtimeSpeechConnectException {
        if (this.session == null || this.status.equals((Object)Status.DISCONNECTED)) {
            LOG.error("Session has been closed, cannot send audio anymore");
            throw new RealtimeSpeechConnectException("Session has been closed, cannot send audio anymore");
        }
        try {
            if (!this.status.equals((Object)Status.CONNECTED)) {
                this.status = Status.ERROR;
                throw new RealtimeSpeechConnectException("Could not send audio data to the realtime speech service");
            }
            this.session.getRemote().sendBytes(ByteBuffer.wrap(audioBytes));
        }
        catch (IOException e) {
            this.status = Status.ERROR;
            LOG.error("Send exception {}", (Throwable)e);
            throw new RealtimeSpeechConnectException(e);
        }
    }

    public void close() {
        this.isClosureClientInitiated = true;
        LOG.info("Closing SDK connection");
        try {
            if (this.session != null) {
                LOG.info("Here are the sessions shared by the client: {}", (Object)this.webSocketClient.getOpenSessions().stream().count());
                this.session.close(1000, "Session Closed by Client");
            }
        }
        catch (Exception e) {
            LOG.warn("Encountered an issue while closing the session: {}", (Object)e.getMessage());
        }
        this.isConnected = false;
        this.authenticationDetailsProvider = null;
    }

    private void sendCreds(String compartmentId) {
        RequestSigner requestSigner = this.getRequestSignerFromAuthenticationDetailsProvider(this.authenticationDetailsProvider);
        LOG.info("Sending credentials");
        HashMap headers = new HashMap();
        Map newHeaders = requestSigner.signRequest(this.destUri, "GET", headers, null);
        newHeaders.put("uri", this.destUri.toString());
        RealtimeMessageAuthenticationCredentials authenticationMessage = RealtimeMessageAuthenticationCredentials.builder().compartmentId(compartmentId).headers(newHeaders).build();
        try {
            this.sendMessage(this.objectMapper.writeValueAsString((Object)authenticationMessage));
        }
        catch (JsonProcessingException e) {
            LOG.info("Could not serialize authentication credentials: {}", (Throwable)e);
            this.status = Status.ERROR;
        }
        LOG.info("Credentials sent");
    }

    public void sendMessage(String message) {
        try {
            this.session.getRemote().sendString(message);
        }
        catch (IOException e) {
            LOG.info("Could not send message to the remote server: {}", (Throwable)e);
            this.status = Status.ERROR;
        }
    }

    public void requestFinalResult() {
        try {
            String message = this.objectMapper.writeValueAsString((Object)RealtimeMessageSendFinalResult.builder().build());
            LOG.info("Requesting final result: " + message);
            this.sendMessage(message);
        }
        catch (IOException e) {
            LOG.info("Could not request final result from the remote server: {}", (Throwable)e);
            this.status = Status.ERROR;
        }
    }

    @VisibleForTesting
    protected RequestSigner getRequestSignerFromAuthenticationDetailsProvider(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        return DefaultRequestSigner.createRequestSigner((BasicAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        CONNECTED,
        CONNECTING,
        DISCONNECTED,
        ERROR;

    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        RealtimeSpeechClientListener listener;
        BasicAuthenticationDetailsProvider authenticationDetailsProvider;
        WebSocketClient webSocketClient;
        String compartmentId;

        public Builder listener(RealtimeSpeechClientListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder authenticationDetailsProvider(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
            this.authenticationDetailsProvider = authenticationDetailsProvider;
            return this;
        }

        public Builder webSocketClient(WebSocketClient webSocketClient) {
            this.webSocketClient = webSocketClient;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public RealtimeSpeechClient build() {
            if (StringUtils.isBlank((String)this.compartmentId)) {
                throw new IllegalStateException("Please initialize with a non-null compartmentId");
            }
            if (this.listener == null) {
                throw new IllegalStateException("Please initialize the listener parameter");
            }
            if (this.authenticationDetailsProvider == null) {
                throw new IllegalStateException("Please initialize the authentication details provider");
            }
            if (this.webSocketClient == null) {
                throw new IllegalStateException("Please initialize the websocket client");
            }
            return new RealtimeSpeechClient(this.listener, this.authenticationDetailsProvider, this.compartmentId, this.webSocketClient);
        }
    }
}

