/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.graalvm.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ReflectionUtils {
    public static Set<Class> getAllInterfaces(Class<?> aClass) {
        HashSet<Class> interfaces = new HashSet<Class>();
        return ReflectionUtils.populateInterfaces(aClass, interfaces);
    }

    protected static Set<Class> populateInterfaces(Class<?> aClass, Set<Class> interfaces) {
        Class<?>[] theInterfaces = aClass.getInterfaces();
        interfaces.addAll(Arrays.asList(theInterfaces));
        for (Class<?> theInterface : theInterfaces) {
            ReflectionUtils.populateInterfaces(theInterface, interfaces);
        }
        if (!aClass.isInterface()) {
            for (Class<?> superclass = aClass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
                ReflectionUtils.populateInterfaces(superclass, interfaces);
            }
        }
        return interfaces;
    }
}

