/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.ConfigSeverity;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DetectConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="exclusions")
    private final List<String> exclusions;
    @JsonProperty(value="upgradePolicy")
    private final UpgradePolicy upgradePolicy;
    @JsonProperty(value="maxPermissibleCvssV2Score")
    private final Float maxPermissibleCvssV2Score;
    @JsonProperty(value="maxPermissibleCvssV3Score")
    private final Float maxPermissibleCvssV3Score;
    @JsonProperty(value="maxPermissibleSeverity")
    private final ConfigSeverity maxPermissibleSeverity;

    @Deprecated
    @ConstructorProperties(value={"exclusions", "upgradePolicy", "maxPermissibleCvssV2Score", "maxPermissibleCvssV3Score", "maxPermissibleSeverity"})
    public DetectConfiguration(List<String> exclusions, UpgradePolicy upgradePolicy, Float maxPermissibleCvssV2Score, Float maxPermissibleCvssV3Score, ConfigSeverity maxPermissibleSeverity) {
        this.exclusions = exclusions;
        this.upgradePolicy = upgradePolicy;
        this.maxPermissibleCvssV2Score = maxPermissibleCvssV2Score;
        this.maxPermissibleCvssV3Score = maxPermissibleCvssV3Score;
        this.maxPermissibleSeverity = maxPermissibleSeverity;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }

    public UpgradePolicy getUpgradePolicy() {
        return this.upgradePolicy;
    }

    public Float getMaxPermissibleCvssV2Score() {
        return this.maxPermissibleCvssV2Score;
    }

    public Float getMaxPermissibleCvssV3Score() {
        return this.maxPermissibleCvssV3Score;
    }

    public ConfigSeverity getMaxPermissibleSeverity() {
        return this.maxPermissibleSeverity;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DetectConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("exclusions=").append(String.valueOf(this.exclusions));
        sb.append(", upgradePolicy=").append(String.valueOf((Object)this.upgradePolicy));
        sb.append(", maxPermissibleCvssV2Score=").append(String.valueOf(this.maxPermissibleCvssV2Score));
        sb.append(", maxPermissibleCvssV3Score=").append(String.valueOf(this.maxPermissibleCvssV3Score));
        sb.append(", maxPermissibleSeverity=").append(String.valueOf((Object)this.maxPermissibleSeverity));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectConfiguration)) {
            return false;
        }
        DetectConfiguration other = (DetectConfiguration)((Object)o);
        return Objects.equals(this.exclusions, other.exclusions) && Objects.equals((Object)this.upgradePolicy, (Object)other.upgradePolicy) && Objects.equals(this.maxPermissibleCvssV2Score, other.maxPermissibleCvssV2Score) && Objects.equals(this.maxPermissibleCvssV3Score, other.maxPermissibleCvssV3Score) && Objects.equals((Object)this.maxPermissibleSeverity, (Object)other.maxPermissibleSeverity) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.exclusions == null ? 43 : this.exclusions.hashCode());
        result = result * 59 + (this.upgradePolicy == null ? 43 : this.upgradePolicy.hashCode());
        result = result * 59 + (this.maxPermissibleCvssV2Score == null ? 43 : this.maxPermissibleCvssV2Score.hashCode());
        result = result * 59 + (this.maxPermissibleCvssV3Score == null ? 43 : this.maxPermissibleCvssV3Score.hashCode());
        result = result * 59 + (this.maxPermissibleSeverity == null ? 43 : this.maxPermissibleSeverity.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UpgradePolicy implements BmcEnum
    {
        Nearest("NEAREST"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UpgradePolicy> map;

        private UpgradePolicy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UpgradePolicy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UpgradePolicy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UpgradePolicy.class);
            map = new HashMap<String, UpgradePolicy>();
            for (UpgradePolicy v : UpgradePolicy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="exclusions")
        private List<String> exclusions;
        @JsonProperty(value="upgradePolicy")
        private UpgradePolicy upgradePolicy;
        @JsonProperty(value="maxPermissibleCvssV2Score")
        private Float maxPermissibleCvssV2Score;
        @JsonProperty(value="maxPermissibleCvssV3Score")
        private Float maxPermissibleCvssV3Score;
        @JsonProperty(value="maxPermissibleSeverity")
        private ConfigSeverity maxPermissibleSeverity;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder exclusions(List<String> exclusions) {
            this.exclusions = exclusions;
            this.__explicitlySet__.add("exclusions");
            return this;
        }

        public Builder upgradePolicy(UpgradePolicy upgradePolicy) {
            this.upgradePolicy = upgradePolicy;
            this.__explicitlySet__.add("upgradePolicy");
            return this;
        }

        public Builder maxPermissibleCvssV2Score(Float maxPermissibleCvssV2Score) {
            this.maxPermissibleCvssV2Score = maxPermissibleCvssV2Score;
            this.__explicitlySet__.add("maxPermissibleCvssV2Score");
            return this;
        }

        public Builder maxPermissibleCvssV3Score(Float maxPermissibleCvssV3Score) {
            this.maxPermissibleCvssV3Score = maxPermissibleCvssV3Score;
            this.__explicitlySet__.add("maxPermissibleCvssV3Score");
            return this;
        }

        public Builder maxPermissibleSeverity(ConfigSeverity maxPermissibleSeverity) {
            this.maxPermissibleSeverity = maxPermissibleSeverity;
            this.__explicitlySet__.add("maxPermissibleSeverity");
            return this;
        }

        public DetectConfiguration build() {
            DetectConfiguration model = new DetectConfiguration(this.exclusions, this.upgradePolicy, this.maxPermissibleCvssV2Score, this.maxPermissibleCvssV3Score, this.maxPermissibleSeverity);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DetectConfiguration model) {
            if (model.wasPropertyExplicitlySet("exclusions")) {
                this.exclusions(model.getExclusions());
            }
            if (model.wasPropertyExplicitlySet("upgradePolicy")) {
                this.upgradePolicy(model.getUpgradePolicy());
            }
            if (model.wasPropertyExplicitlySet("maxPermissibleCvssV2Score")) {
                this.maxPermissibleCvssV2Score(model.getMaxPermissibleCvssV2Score());
            }
            if (model.wasPropertyExplicitlySet("maxPermissibleCvssV3Score")) {
                this.maxPermissibleCvssV3Score(model.getMaxPermissibleCvssV3Score());
            }
            if (model.wasPropertyExplicitlySet("maxPermissibleSeverity")) {
                this.maxPermissibleSeverity(model.getMaxPermissibleSeverity());
            }
            return this;
        }
    }
}

