/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.VerifyConfiguration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="buildServiceType")
@JsonFilter(value="explicitlySetFilter")
public final class JenkinsPipelineConfiguration
extends VerifyConfiguration {
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="patSecretId")
    private final String patSecretId;
    @JsonProperty(value="jenkinsUrl")
    private final String jenkinsUrl;
    @JsonProperty(value="jobName")
    private final String jobName;
    @JsonProperty(value="additionalParameters")
    private final Map<String, String> additionalParameters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public JenkinsPipelineConfiguration(String username, String patSecretId, String jenkinsUrl, String jobName, Map<String, String> additionalParameters) {
        this.username = username;
        this.patSecretId = patSecretId;
        this.jenkinsUrl = jenkinsUrl;
        this.jobName = jobName;
        this.additionalParameters = additionalParameters;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPatSecretId() {
        return this.patSecretId;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public String getJobName() {
        return this.jobName;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JenkinsPipelineConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", patSecretId=").append(String.valueOf(this.patSecretId));
        sb.append(", jenkinsUrl=").append(String.valueOf(this.jenkinsUrl));
        sb.append(", jobName=").append(String.valueOf(this.jobName));
        sb.append(", additionalParameters=").append(String.valueOf(this.additionalParameters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JenkinsPipelineConfiguration)) {
            return false;
        }
        JenkinsPipelineConfiguration other = (JenkinsPipelineConfiguration)((Object)o);
        return Objects.equals(this.username, other.username) && Objects.equals(this.patSecretId, other.patSecretId) && Objects.equals(this.jenkinsUrl, other.jenkinsUrl) && Objects.equals(this.jobName, other.jobName) && Objects.equals(this.additionalParameters, other.additionalParameters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.patSecretId == null ? 43 : this.patSecretId.hashCode());
        result = result * 59 + (this.jenkinsUrl == null ? 43 : this.jenkinsUrl.hashCode());
        result = result * 59 + (this.jobName == null ? 43 : this.jobName.hashCode());
        result = result * 59 + (this.additionalParameters == null ? 43 : this.additionalParameters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="patSecretId")
        private String patSecretId;
        @JsonProperty(value="jenkinsUrl")
        private String jenkinsUrl;
        @JsonProperty(value="jobName")
        private String jobName;
        @JsonProperty(value="additionalParameters")
        private Map<String, String> additionalParameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder patSecretId(String patSecretId) {
            this.patSecretId = patSecretId;
            this.__explicitlySet__.add("patSecretId");
            return this;
        }

        public Builder jenkinsUrl(String jenkinsUrl) {
            this.jenkinsUrl = jenkinsUrl;
            this.__explicitlySet__.add("jenkinsUrl");
            return this;
        }

        public Builder jobName(String jobName) {
            this.jobName = jobName;
            this.__explicitlySet__.add("jobName");
            return this;
        }

        public Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = additionalParameters;
            this.__explicitlySet__.add("additionalParameters");
            return this;
        }

        public JenkinsPipelineConfiguration build() {
            JenkinsPipelineConfiguration model = new JenkinsPipelineConfiguration(this.username, this.patSecretId, this.jenkinsUrl, this.jobName, this.additionalParameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JenkinsPipelineConfiguration model) {
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("patSecretId")) {
                this.patSecretId(model.getPatSecretId());
            }
            if (model.wasPropertyExplicitlySet("jenkinsUrl")) {
                this.jenkinsUrl(model.getJenkinsUrl());
            }
            if (model.wasPropertyExplicitlySet("jobName")) {
                this.jobName(model.getJobName());
            }
            if (model.wasPropertyExplicitlySet("additionalParameters")) {
                this.additionalParameters(model.getAdditionalParameters());
            }
            return this;
        }
    }
}

