/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.VerifyConfiguration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="buildServiceType")
@JsonFilter(value="explicitlySetFilter")
public final class OciDevOpsBuildConfiguration
extends VerifyConfiguration {
    @JsonProperty(value="pipelineId")
    private final String pipelineId;
    @JsonProperty(value="additionalParameters")
    private final Map<String, String> additionalParameters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OciDevOpsBuildConfiguration(String pipelineId, Map<String, String> additionalParameters) {
        this.pipelineId = pipelineId;
        this.additionalParameters = additionalParameters;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciDevOpsBuildConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", pipelineId=").append(String.valueOf(this.pipelineId));
        sb.append(", additionalParameters=").append(String.valueOf(this.additionalParameters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciDevOpsBuildConfiguration)) {
            return false;
        }
        OciDevOpsBuildConfiguration other = (OciDevOpsBuildConfiguration)((Object)o);
        return Objects.equals(this.pipelineId, other.pipelineId) && Objects.equals(this.additionalParameters, other.additionalParameters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineId == null ? 43 : this.pipelineId.hashCode());
        result = result * 59 + (this.additionalParameters == null ? 43 : this.additionalParameters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pipelineId")
        private String pipelineId;
        @JsonProperty(value="additionalParameters")
        private Map<String, String> additionalParameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            this.__explicitlySet__.add("pipelineId");
            return this;
        }

        public Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = additionalParameters;
            this.__explicitlySet__.add("additionalParameters");
            return this;
        }

        public OciDevOpsBuildConfiguration build() {
            OciDevOpsBuildConfiguration model = new OciDevOpsBuildConfiguration(this.pipelineId, this.additionalParameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciDevOpsBuildConfiguration model) {
            if (model.wasPropertyExplicitlySet("pipelineId")) {
                this.pipelineId(model.getPipelineId());
            }
            if (model.wasPropertyExplicitlySet("additionalParameters")) {
                this.additionalParameters(model.getAdditionalParameters());
            }
            return this;
        }
    }
}

