/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.PullRequestProperties;
import com.oracle.bmc.adm.model.RemediationRunStage;
import com.oracle.bmc.adm.model.RemediationRunStageType;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class RecommendStage
extends RemediationRunStage {
    @JsonProperty(value="recommendedUpdatesCount")
    private final Integer recommendedUpdatesCount;
    @JsonProperty(value="pullRequestProperties")
    private final PullRequestProperties pullRequestProperties;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RecommendStage(RemediationRunStage.Status status, Date timeCreated, Date timeStarted, Date timeFinished, String summary, String remediationRunId, RemediationRunStageType previousStageType, RemediationRunStageType nextStageType, Integer recommendedUpdatesCount, PullRequestProperties pullRequestProperties) {
        super(status, timeCreated, timeStarted, timeFinished, summary, remediationRunId, previousStageType, nextStageType);
        this.recommendedUpdatesCount = recommendedUpdatesCount;
        this.pullRequestProperties = pullRequestProperties;
    }

    public Integer getRecommendedUpdatesCount() {
        return this.recommendedUpdatesCount;
    }

    public PullRequestProperties getPullRequestProperties() {
        return this.pullRequestProperties;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RecommendStage(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", recommendedUpdatesCount=").append(String.valueOf(this.recommendedUpdatesCount));
        sb.append(", pullRequestProperties=").append(String.valueOf((Object)this.pullRequestProperties));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecommendStage)) {
            return false;
        }
        RecommendStage other = (RecommendStage)((Object)o);
        return Objects.equals(this.recommendedUpdatesCount, other.recommendedUpdatesCount) && Objects.equals((Object)this.pullRequestProperties, (Object)other.pullRequestProperties) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.recommendedUpdatesCount == null ? 43 : this.recommendedUpdatesCount.hashCode());
        result = result * 59 + (this.pullRequestProperties == null ? 43 : this.pullRequestProperties.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private RemediationRunStage.Status status;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="remediationRunId")
        private String remediationRunId;
        @JsonProperty(value="previousStageType")
        private RemediationRunStageType previousStageType;
        @JsonProperty(value="nextStageType")
        private RemediationRunStageType nextStageType;
        @JsonProperty(value="recommendedUpdatesCount")
        private Integer recommendedUpdatesCount;
        @JsonProperty(value="pullRequestProperties")
        private PullRequestProperties pullRequestProperties;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(RemediationRunStage.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder remediationRunId(String remediationRunId) {
            this.remediationRunId = remediationRunId;
            this.__explicitlySet__.add("remediationRunId");
            return this;
        }

        public Builder previousStageType(RemediationRunStageType previousStageType) {
            this.previousStageType = previousStageType;
            this.__explicitlySet__.add("previousStageType");
            return this;
        }

        public Builder nextStageType(RemediationRunStageType nextStageType) {
            this.nextStageType = nextStageType;
            this.__explicitlySet__.add("nextStageType");
            return this;
        }

        public Builder recommendedUpdatesCount(Integer recommendedUpdatesCount) {
            this.recommendedUpdatesCount = recommendedUpdatesCount;
            this.__explicitlySet__.add("recommendedUpdatesCount");
            return this;
        }

        public Builder pullRequestProperties(PullRequestProperties pullRequestProperties) {
            this.pullRequestProperties = pullRequestProperties;
            this.__explicitlySet__.add("pullRequestProperties");
            return this;
        }

        public RecommendStage build() {
            RecommendStage model = new RecommendStage(this.status, this.timeCreated, this.timeStarted, this.timeFinished, this.summary, this.remediationRunId, this.previousStageType, this.nextStageType, this.recommendedUpdatesCount, this.pullRequestProperties);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RecommendStage model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("remediationRunId")) {
                this.remediationRunId(model.getRemediationRunId());
            }
            if (model.wasPropertyExplicitlySet("previousStageType")) {
                this.previousStageType(model.getPreviousStageType());
            }
            if (model.wasPropertyExplicitlySet("nextStageType")) {
                this.nextStageType(model.getNextStageType());
            }
            if (model.wasPropertyExplicitlySet("recommendedUpdatesCount")) {
                this.recommendedUpdatesCount(model.getRecommendedUpdatesCount());
            }
            if (model.wasPropertyExplicitlySet("pullRequestProperties")) {
                this.pullRequestProperties(model.getPullRequestProperties());
            }
            return this;
        }
    }
}

