/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.RemediationRunStage;
import com.oracle.bmc.adm.model.RemediationRunStageType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RemediationRunStageSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final RemediationRunStage.Status status;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="type")
    private final RemediationRunStageType type;
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="remediationRunId")
    private final String remediationRunId;

    @Deprecated
    @ConstructorProperties(value={"status", "timeCreated", "timeStarted", "timeFinished", "type", "summary", "remediationRunId"})
    public RemediationRunStageSummary(RemediationRunStage.Status status, Date timeCreated, Date timeStarted, Date timeFinished, RemediationRunStageType type, String summary, String remediationRunId) {
        this.status = status;
        this.timeCreated = timeCreated;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.type = type;
        this.summary = summary;
        this.remediationRunId = remediationRunId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public RemediationRunStage.Status getStatus() {
        return this.status;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public RemediationRunStageType getType() {
        return this.type;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getRemediationRunId() {
        return this.remediationRunId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RemediationRunStageSummary(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", remediationRunId=").append(String.valueOf(this.remediationRunId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RemediationRunStageSummary)) {
            return false;
        }
        RemediationRunStageSummary other = (RemediationRunStageSummary)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.summary, other.summary) && Objects.equals(this.remediationRunId, other.remediationRunId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.remediationRunId == null ? 43 : this.remediationRunId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private RemediationRunStage.Status status;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="type")
        private RemediationRunStageType type;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="remediationRunId")
        private String remediationRunId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(RemediationRunStage.Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder type(RemediationRunStageType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder remediationRunId(String remediationRunId) {
            this.remediationRunId = remediationRunId;
            this.__explicitlySet__.add("remediationRunId");
            return this;
        }

        public RemediationRunStageSummary build() {
            RemediationRunStageSummary model = new RemediationRunStageSummary(this.status, this.timeCreated, this.timeStarted, this.timeFinished, this.type, this.summary, this.remediationRunId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RemediationRunStageSummary model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("remediationRunId")) {
                this.remediationRunId(model.getRemediationRunId());
            }
            return this;
        }
    }
}

