/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.adm.model.ExternalScmConfiguration;
import com.oracle.bmc.adm.model.OciCodeRepositoryConfiguration;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="scmType", defaultImpl=ScmConfiguration.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=OciCodeRepositoryConfiguration.class, name="OCI_CODE_REPOSITORY"), @JsonSubTypes.Type(value=ExternalScmConfiguration.class, name="EXTERNAL_SCM")})
@JsonFilter(value="explicitlySetFilter")
public class ScmConfiguration
extends ExplicitlySetBmcModel {
    @JsonProperty(value="branch")
    private final String branch;
    @JsonProperty(value="buildFileLocation")
    private final String buildFileLocation;
    @JsonProperty(value="isAutomergeEnabled")
    private final Boolean isAutomergeEnabled;

    @Deprecated
    @ConstructorProperties(value={"branch", "buildFileLocation", "isAutomergeEnabled"})
    protected ScmConfiguration(String branch, String buildFileLocation, Boolean isAutomergeEnabled) {
        this.branch = branch;
        this.buildFileLocation = buildFileLocation;
        this.isAutomergeEnabled = isAutomergeEnabled;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBuildFileLocation() {
        return this.buildFileLocation;
    }

    public Boolean getIsAutomergeEnabled() {
        return this.isAutomergeEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ScmConfiguration(");
        sb.append("super=").append(super.toString());
        sb.append("branch=").append(String.valueOf(this.branch));
        sb.append(", buildFileLocation=").append(String.valueOf(this.buildFileLocation));
        sb.append(", isAutomergeEnabled=").append(String.valueOf(this.isAutomergeEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScmConfiguration)) {
            return false;
        }
        ScmConfiguration other = (ScmConfiguration)((Object)o);
        return Objects.equals(this.branch, other.branch) && Objects.equals(this.buildFileLocation, other.buildFileLocation) && Objects.equals(this.isAutomergeEnabled, other.isAutomergeEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.branch == null ? 43 : this.branch.hashCode());
        result = result * 59 + (this.buildFileLocation == null ? 43 : this.buildFileLocation.hashCode());
        result = result * 59 + (this.isAutomergeEnabled == null ? 43 : this.isAutomergeEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ScmType implements BmcEnum
    {
        OciCodeRepository("OCI_CODE_REPOSITORY"),
        ExternalScm("EXTERNAL_SCM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ScmType> map;

        private ScmType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ScmType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ScmType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ScmType.class);
            map = new HashMap<String, ScmType>();
            for (ScmType v : ScmType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

