/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.UsageDataDetails;
import com.oracle.bmc.adm.model.Vulnerability;
import com.oracle.bmc.adm.model.VulnerabilityAuditConfiguration;
import com.oracle.bmc.adm.model.VulnerabilityAuditSource;
import com.oracle.bmc.adm.model.VulnerabilitySeverity;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class VulnerabilityAudit
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="knowledgeBaseId")
    private final String knowledgeBaseId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final LifecycleDetails lifecycleDetails;
    @JsonProperty(value="vulnerabilities")
    private final List<Vulnerability> vulnerabilities;
    @JsonProperty(value="maxObservedCvssV2Score")
    private final Float maxObservedCvssV2Score;
    @JsonProperty(value="maxObservedCvssV3Score")
    private final Float maxObservedCvssV3Score;
    @JsonProperty(value="maxObservedSeverity")
    private final VulnerabilitySeverity maxObservedSeverity;
    @JsonProperty(value="maxObservedCvssV2ScoreWithIgnored")
    private final Float maxObservedCvssV2ScoreWithIgnored;
    @JsonProperty(value="maxObservedCvssV3ScoreWithIgnored")
    private final Float maxObservedCvssV3ScoreWithIgnored;
    @JsonProperty(value="maxObservedSeverityWithIgnored")
    private final VulnerabilitySeverity maxObservedSeverityWithIgnored;
    @JsonProperty(value="vulnerableArtifactsCountWithIgnored")
    private final Integer vulnerableArtifactsCountWithIgnored;
    @JsonProperty(value="vulnerableArtifactsCount")
    private final Integer vulnerableArtifactsCount;
    @JsonProperty(value="configuration")
    private final VulnerabilityAuditConfiguration configuration;
    @JsonProperty(value="usageData")
    private final UsageDataDetails usageData;
    @JsonProperty(value="isSuccess")
    private final Boolean isSuccess;
    @JsonProperty(value="buildType")
    private final BuildType buildType;
    @JsonProperty(value="source")
    private final VulnerabilityAuditSource source;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "knowledgeBaseId", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "vulnerabilities", "maxObservedCvssV2Score", "maxObservedCvssV3Score", "maxObservedSeverity", "maxObservedCvssV2ScoreWithIgnored", "maxObservedCvssV3ScoreWithIgnored", "maxObservedSeverityWithIgnored", "vulnerableArtifactsCountWithIgnored", "vulnerableArtifactsCount", "configuration", "usageData", "isSuccess", "buildType", "source", "compartmentId", "freeformTags", "definedTags", "systemTags"})
    public VulnerabilityAudit(String id, String displayName, String knowledgeBaseId, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, LifecycleDetails lifecycleDetails, List<Vulnerability> vulnerabilities, Float maxObservedCvssV2Score, Float maxObservedCvssV3Score, VulnerabilitySeverity maxObservedSeverity, Float maxObservedCvssV2ScoreWithIgnored, Float maxObservedCvssV3ScoreWithIgnored, VulnerabilitySeverity maxObservedSeverityWithIgnored, Integer vulnerableArtifactsCountWithIgnored, Integer vulnerableArtifactsCount, VulnerabilityAuditConfiguration configuration, UsageDataDetails usageData, Boolean isSuccess, BuildType buildType, VulnerabilityAuditSource source, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.knowledgeBaseId = knowledgeBaseId;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.vulnerabilities = vulnerabilities;
        this.maxObservedCvssV2Score = maxObservedCvssV2Score;
        this.maxObservedCvssV3Score = maxObservedCvssV3Score;
        this.maxObservedSeverity = maxObservedSeverity;
        this.maxObservedCvssV2ScoreWithIgnored = maxObservedCvssV2ScoreWithIgnored;
        this.maxObservedCvssV3ScoreWithIgnored = maxObservedCvssV3ScoreWithIgnored;
        this.maxObservedSeverityWithIgnored = maxObservedSeverityWithIgnored;
        this.vulnerableArtifactsCountWithIgnored = vulnerableArtifactsCountWithIgnored;
        this.vulnerableArtifactsCount = vulnerableArtifactsCount;
        this.configuration = configuration;
        this.usageData = usageData;
        this.isSuccess = isSuccess;
        this.buildType = buildType;
        this.source = source;
        this.compartmentId = compartmentId;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public LifecycleDetails getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<Vulnerability> getVulnerabilities() {
        return this.vulnerabilities;
    }

    public Float getMaxObservedCvssV2Score() {
        return this.maxObservedCvssV2Score;
    }

    public Float getMaxObservedCvssV3Score() {
        return this.maxObservedCvssV3Score;
    }

    public VulnerabilitySeverity getMaxObservedSeverity() {
        return this.maxObservedSeverity;
    }

    public Float getMaxObservedCvssV2ScoreWithIgnored() {
        return this.maxObservedCvssV2ScoreWithIgnored;
    }

    public Float getMaxObservedCvssV3ScoreWithIgnored() {
        return this.maxObservedCvssV3ScoreWithIgnored;
    }

    public VulnerabilitySeverity getMaxObservedSeverityWithIgnored() {
        return this.maxObservedSeverityWithIgnored;
    }

    public Integer getVulnerableArtifactsCountWithIgnored() {
        return this.vulnerableArtifactsCountWithIgnored;
    }

    public Integer getVulnerableArtifactsCount() {
        return this.vulnerableArtifactsCount;
    }

    public VulnerabilityAuditConfiguration getConfiguration() {
        return this.configuration;
    }

    public UsageDataDetails getUsageData() {
        return this.usageData;
    }

    public Boolean getIsSuccess() {
        return this.isSuccess;
    }

    public BuildType getBuildType() {
        return this.buildType;
    }

    public VulnerabilityAuditSource getSource() {
        return this.source;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VulnerabilityAudit(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", knowledgeBaseId=").append(String.valueOf(this.knowledgeBaseId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf((Object)this.lifecycleDetails));
        sb.append(", vulnerabilities=").append(String.valueOf(this.vulnerabilities));
        sb.append(", maxObservedCvssV2Score=").append(String.valueOf(this.maxObservedCvssV2Score));
        sb.append(", maxObservedCvssV3Score=").append(String.valueOf(this.maxObservedCvssV3Score));
        sb.append(", maxObservedSeverity=").append(String.valueOf((Object)this.maxObservedSeverity));
        sb.append(", maxObservedCvssV2ScoreWithIgnored=").append(String.valueOf(this.maxObservedCvssV2ScoreWithIgnored));
        sb.append(", maxObservedCvssV3ScoreWithIgnored=").append(String.valueOf(this.maxObservedCvssV3ScoreWithIgnored));
        sb.append(", maxObservedSeverityWithIgnored=").append(String.valueOf((Object)this.maxObservedSeverityWithIgnored));
        sb.append(", vulnerableArtifactsCountWithIgnored=").append(String.valueOf(this.vulnerableArtifactsCountWithIgnored));
        sb.append(", vulnerableArtifactsCount=").append(String.valueOf(this.vulnerableArtifactsCount));
        sb.append(", configuration=").append(String.valueOf((Object)this.configuration));
        sb.append(", usageData=").append(String.valueOf((Object)this.usageData));
        sb.append(", isSuccess=").append(String.valueOf(this.isSuccess));
        sb.append(", buildType=").append(String.valueOf((Object)this.buildType));
        sb.append(", source=").append(String.valueOf((Object)this.source));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VulnerabilityAudit)) {
            return false;
        }
        VulnerabilityAudit other = (VulnerabilityAudit)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.knowledgeBaseId, other.knowledgeBaseId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifecycleDetails, (Object)other.lifecycleDetails) && Objects.equals(this.vulnerabilities, other.vulnerabilities) && Objects.equals(this.maxObservedCvssV2Score, other.maxObservedCvssV2Score) && Objects.equals(this.maxObservedCvssV3Score, other.maxObservedCvssV3Score) && Objects.equals((Object)this.maxObservedSeverity, (Object)other.maxObservedSeverity) && Objects.equals(this.maxObservedCvssV2ScoreWithIgnored, other.maxObservedCvssV2ScoreWithIgnored) && Objects.equals(this.maxObservedCvssV3ScoreWithIgnored, other.maxObservedCvssV3ScoreWithIgnored) && Objects.equals((Object)this.maxObservedSeverityWithIgnored, (Object)other.maxObservedSeverityWithIgnored) && Objects.equals(this.vulnerableArtifactsCountWithIgnored, other.vulnerableArtifactsCountWithIgnored) && Objects.equals(this.vulnerableArtifactsCount, other.vulnerableArtifactsCount) && Objects.equals((Object)this.configuration, (Object)other.configuration) && Objects.equals((Object)this.usageData, (Object)other.usageData) && Objects.equals(this.isSuccess, other.isSuccess) && Objects.equals((Object)this.buildType, (Object)other.buildType) && Objects.equals((Object)this.source, (Object)other.source) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.knowledgeBaseId == null ? 43 : this.knowledgeBaseId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.vulnerabilities == null ? 43 : this.vulnerabilities.hashCode());
        result = result * 59 + (this.maxObservedCvssV2Score == null ? 43 : this.maxObservedCvssV2Score.hashCode());
        result = result * 59 + (this.maxObservedCvssV3Score == null ? 43 : this.maxObservedCvssV3Score.hashCode());
        result = result * 59 + (this.maxObservedSeverity == null ? 43 : this.maxObservedSeverity.hashCode());
        result = result * 59 + (this.maxObservedCvssV2ScoreWithIgnored == null ? 43 : this.maxObservedCvssV2ScoreWithIgnored.hashCode());
        result = result * 59 + (this.maxObservedCvssV3ScoreWithIgnored == null ? 43 : this.maxObservedCvssV3ScoreWithIgnored.hashCode());
        result = result * 59 + (this.maxObservedSeverityWithIgnored == null ? 43 : this.maxObservedSeverityWithIgnored.hashCode());
        result = result * 59 + (this.vulnerableArtifactsCountWithIgnored == null ? 43 : this.vulnerableArtifactsCountWithIgnored.hashCode());
        result = result * 59 + (this.vulnerableArtifactsCount == null ? 43 : this.vulnerableArtifactsCount.hashCode());
        result = result * 59 + (this.configuration == null ? 43 : this.configuration.hashCode());
        result = result * 59 + (this.usageData == null ? 43 : this.usageData.hashCode());
        result = result * 59 + (this.isSuccess == null ? 43 : this.isSuccess.hashCode());
        result = result * 59 + (this.buildType == null ? 43 : this.buildType.hashCode());
        result = result * 59 + (this.source == null ? 43 : this.source.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BuildType implements BmcEnum
    {
        Maven("MAVEN"),
        Unset("UNSET"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, BuildType> map;

        private BuildType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BuildType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'BuildType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(BuildType.class);
            map = new HashMap<String, BuildType>();
            for (BuildType v : BuildType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleDetails implements BmcEnum
    {
        UsageDataNotFoundOrNotAuthorized("USAGE_DATA_NOT_FOUND_OR_NOT_AUTHORIZED"),
        UsageDataParseFailed("USAGE_DATA_PARSE_FAILED"),
        UsageDataCompressedSizeLimitExceeded("USAGE_DATA_COMPRESSED_SIZE_LIMIT_EXCEEDED"),
        UsageDataUncompressedSizeLimitExceeded("USAGE_DATA_UNCOMPRESSED_SIZE_LIMIT_EXCEEDED"),
        UsageDataUnknownError("USAGE_DATA_UNKNOWN_ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleDetails> map;

        private LifecycleDetails(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleDetails create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleDetails', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleDetails.class);
            map = new HashMap<String, LifecycleDetails>();
            for (LifecycleDetails v : LifecycleDetails.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Active("ACTIVE"),
        Creating("CREATING"),
        Deleted("DELETED"),
        Deleting("DELETING"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="knowledgeBaseId")
        private String knowledgeBaseId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private LifecycleDetails lifecycleDetails;
        @JsonProperty(value="vulnerabilities")
        private List<Vulnerability> vulnerabilities;
        @JsonProperty(value="maxObservedCvssV2Score")
        private Float maxObservedCvssV2Score;
        @JsonProperty(value="maxObservedCvssV3Score")
        private Float maxObservedCvssV3Score;
        @JsonProperty(value="maxObservedSeverity")
        private VulnerabilitySeverity maxObservedSeverity;
        @JsonProperty(value="maxObservedCvssV2ScoreWithIgnored")
        private Float maxObservedCvssV2ScoreWithIgnored;
        @JsonProperty(value="maxObservedCvssV3ScoreWithIgnored")
        private Float maxObservedCvssV3ScoreWithIgnored;
        @JsonProperty(value="maxObservedSeverityWithIgnored")
        private VulnerabilitySeverity maxObservedSeverityWithIgnored;
        @JsonProperty(value="vulnerableArtifactsCountWithIgnored")
        private Integer vulnerableArtifactsCountWithIgnored;
        @JsonProperty(value="vulnerableArtifactsCount")
        private Integer vulnerableArtifactsCount;
        @JsonProperty(value="configuration")
        private VulnerabilityAuditConfiguration configuration;
        @JsonProperty(value="usageData")
        private UsageDataDetails usageData;
        @JsonProperty(value="isSuccess")
        private Boolean isSuccess;
        @JsonProperty(value="buildType")
        private BuildType buildType;
        @JsonProperty(value="source")
        private VulnerabilityAuditSource source;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            this.__explicitlySet__.add("knowledgeBaseId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(LifecycleDetails lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder vulnerabilities(List<Vulnerability> vulnerabilities) {
            this.vulnerabilities = vulnerabilities;
            this.__explicitlySet__.add("vulnerabilities");
            return this;
        }

        public Builder maxObservedCvssV2Score(Float maxObservedCvssV2Score) {
            this.maxObservedCvssV2Score = maxObservedCvssV2Score;
            this.__explicitlySet__.add("maxObservedCvssV2Score");
            return this;
        }

        public Builder maxObservedCvssV3Score(Float maxObservedCvssV3Score) {
            this.maxObservedCvssV3Score = maxObservedCvssV3Score;
            this.__explicitlySet__.add("maxObservedCvssV3Score");
            return this;
        }

        public Builder maxObservedSeverity(VulnerabilitySeverity maxObservedSeverity) {
            this.maxObservedSeverity = maxObservedSeverity;
            this.__explicitlySet__.add("maxObservedSeverity");
            return this;
        }

        public Builder maxObservedCvssV2ScoreWithIgnored(Float maxObservedCvssV2ScoreWithIgnored) {
            this.maxObservedCvssV2ScoreWithIgnored = maxObservedCvssV2ScoreWithIgnored;
            this.__explicitlySet__.add("maxObservedCvssV2ScoreWithIgnored");
            return this;
        }

        public Builder maxObservedCvssV3ScoreWithIgnored(Float maxObservedCvssV3ScoreWithIgnored) {
            this.maxObservedCvssV3ScoreWithIgnored = maxObservedCvssV3ScoreWithIgnored;
            this.__explicitlySet__.add("maxObservedCvssV3ScoreWithIgnored");
            return this;
        }

        public Builder maxObservedSeverityWithIgnored(VulnerabilitySeverity maxObservedSeverityWithIgnored) {
            this.maxObservedSeverityWithIgnored = maxObservedSeverityWithIgnored;
            this.__explicitlySet__.add("maxObservedSeverityWithIgnored");
            return this;
        }

        public Builder vulnerableArtifactsCountWithIgnored(Integer vulnerableArtifactsCountWithIgnored) {
            this.vulnerableArtifactsCountWithIgnored = vulnerableArtifactsCountWithIgnored;
            this.__explicitlySet__.add("vulnerableArtifactsCountWithIgnored");
            return this;
        }

        public Builder vulnerableArtifactsCount(Integer vulnerableArtifactsCount) {
            this.vulnerableArtifactsCount = vulnerableArtifactsCount;
            this.__explicitlySet__.add("vulnerableArtifactsCount");
            return this;
        }

        public Builder configuration(VulnerabilityAuditConfiguration configuration) {
            this.configuration = configuration;
            this.__explicitlySet__.add("configuration");
            return this;
        }

        public Builder usageData(UsageDataDetails usageData) {
            this.usageData = usageData;
            this.__explicitlySet__.add("usageData");
            return this;
        }

        public Builder isSuccess(Boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.__explicitlySet__.add("isSuccess");
            return this;
        }

        public Builder buildType(BuildType buildType) {
            this.buildType = buildType;
            this.__explicitlySet__.add("buildType");
            return this;
        }

        public Builder source(VulnerabilityAuditSource source) {
            this.source = source;
            this.__explicitlySet__.add("source");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public VulnerabilityAudit build() {
            VulnerabilityAudit model = new VulnerabilityAudit(this.id, this.displayName, this.knowledgeBaseId, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.vulnerabilities, this.maxObservedCvssV2Score, this.maxObservedCvssV3Score, this.maxObservedSeverity, this.maxObservedCvssV2ScoreWithIgnored, this.maxObservedCvssV3ScoreWithIgnored, this.maxObservedSeverityWithIgnored, this.vulnerableArtifactsCountWithIgnored, this.vulnerableArtifactsCount, this.configuration, this.usageData, this.isSuccess, this.buildType, this.source, this.compartmentId, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VulnerabilityAudit model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("knowledgeBaseId")) {
                this.knowledgeBaseId(model.getKnowledgeBaseId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("vulnerabilities")) {
                this.vulnerabilities(model.getVulnerabilities());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV2Score")) {
                this.maxObservedCvssV2Score(model.getMaxObservedCvssV2Score());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV3Score")) {
                this.maxObservedCvssV3Score(model.getMaxObservedCvssV3Score());
            }
            if (model.wasPropertyExplicitlySet("maxObservedSeverity")) {
                this.maxObservedSeverity(model.getMaxObservedSeverity());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV2ScoreWithIgnored")) {
                this.maxObservedCvssV2ScoreWithIgnored(model.getMaxObservedCvssV2ScoreWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("maxObservedCvssV3ScoreWithIgnored")) {
                this.maxObservedCvssV3ScoreWithIgnored(model.getMaxObservedCvssV3ScoreWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("maxObservedSeverityWithIgnored")) {
                this.maxObservedSeverityWithIgnored(model.getMaxObservedSeverityWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("vulnerableArtifactsCountWithIgnored")) {
                this.vulnerableArtifactsCountWithIgnored(model.getVulnerableArtifactsCountWithIgnored());
            }
            if (model.wasPropertyExplicitlySet("vulnerableArtifactsCount")) {
                this.vulnerableArtifactsCount(model.getVulnerableArtifactsCount());
            }
            if (model.wasPropertyExplicitlySet("configuration")) {
                this.configuration(model.getConfiguration());
            }
            if (model.wasPropertyExplicitlySet("usageData")) {
                this.usageData(model.getUsageData());
            }
            if (model.wasPropertyExplicitlySet("isSuccess")) {
                this.isSuccess(model.getIsSuccess());
            }
            if (model.wasPropertyExplicitlySet("buildType")) {
                this.buildType(model.getBuildType());
            }
            if (model.wasPropertyExplicitlySet("source")) {
                this.source(model.getSource());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

