/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.oracle.bmc.adm.model.RemediationRunStageType;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetStageRequest
extends BmcRequest<Void> {
    private String remediationRunId;
    private RemediationRunStageType stageType;
    private String opcRequestId;

    public String getRemediationRunId() {
        return this.remediationRunId;
    }

    public RemediationRunStageType getStageType() {
        return this.stageType;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().remediationRunId(this.remediationRunId).stageType(this.stageType).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",remediationRunId=").append(String.valueOf(this.remediationRunId));
        sb.append(",stageType=").append(String.valueOf((Object)this.stageType));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetStageRequest)) {
            return false;
        }
        GetStageRequest other = (GetStageRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.remediationRunId, other.remediationRunId) && Objects.equals((Object)this.stageType, (Object)other.stageType) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.remediationRunId == null ? 43 : this.remediationRunId.hashCode());
        result = result * 59 + (this.stageType == null ? 43 : this.stageType.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStageRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String remediationRunId = null;
        private RemediationRunStageType stageType = null;
        private String opcRequestId = null;

        public Builder remediationRunId(String remediationRunId) {
            this.remediationRunId = remediationRunId;
            return this;
        }

        public Builder stageType(RemediationRunStageType stageType) {
            this.stageType = stageType;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStageRequest o) {
            this.remediationRunId(o.getRemediationRunId());
            this.stageType(o.getStageType());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStageRequest build() {
            GetStageRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetStageRequest buildWithoutInvocationCallback() {
            GetStageRequest request = new GetStageRequest();
            request.remediationRunId = this.remediationRunId;
            request.stageType = this.stageType;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

