/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.adm.ApplicationDependencyManagement;
import com.oracle.bmc.adm.ApplicationDependencyManagementPaginators;
import com.oracle.bmc.adm.ApplicationDependencyManagementWaiters;
import com.oracle.bmc.adm.model.ApplicationDependencyRecommendationCollection;
import com.oracle.bmc.adm.model.ApplicationDependencyVulnerabilityCollection;
import com.oracle.bmc.adm.model.KnowledgeBase;
import com.oracle.bmc.adm.model.KnowledgeBaseCollection;
import com.oracle.bmc.adm.model.RemediationRecipe;
import com.oracle.bmc.adm.model.RemediationRecipeCollection;
import com.oracle.bmc.adm.model.RemediationRun;
import com.oracle.bmc.adm.model.RemediationRunCollection;
import com.oracle.bmc.adm.model.RemediationRunStage;
import com.oracle.bmc.adm.model.RemediationRunStageCollection;
import com.oracle.bmc.adm.model.VulnerabilityAudit;
import com.oracle.bmc.adm.model.VulnerabilityAuditCollection;
import com.oracle.bmc.adm.model.WorkRequest;
import com.oracle.bmc.adm.model.WorkRequestErrorCollection;
import com.oracle.bmc.adm.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.adm.model.WorkRequestSummaryCollection;
import com.oracle.bmc.adm.requests.ActivateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.CancelRemediationRunRequest;
import com.oracle.bmc.adm.requests.CancelWorkRequestRequest;
import com.oracle.bmc.adm.requests.ChangeKnowledgeBaseCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeRemediationRecipeCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeRemediationRunCompartmentRequest;
import com.oracle.bmc.adm.requests.ChangeVulnerabilityAuditCompartmentRequest;
import com.oracle.bmc.adm.requests.CreateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.CreateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.CreateRemediationRunRequest;
import com.oracle.bmc.adm.requests.CreateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.DeactivateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.DeleteKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.DeleteRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.DeleteRemediationRunRequest;
import com.oracle.bmc.adm.requests.DeleteVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.GetRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.GetRemediationRunRequest;
import com.oracle.bmc.adm.requests.GetStageRequest;
import com.oracle.bmc.adm.requests.GetVulnerabilityAuditRequest;
import com.oracle.bmc.adm.requests.GetWorkRequestRequest;
import com.oracle.bmc.adm.requests.ListApplicationDependencyRecommendationsRequest;
import com.oracle.bmc.adm.requests.ListApplicationDependencyVulnerabilitiesRequest;
import com.oracle.bmc.adm.requests.ListKnowledgeBasesRequest;
import com.oracle.bmc.adm.requests.ListRemediationRecipesRequest;
import com.oracle.bmc.adm.requests.ListRemediationRunsRequest;
import com.oracle.bmc.adm.requests.ListStagesRequest;
import com.oracle.bmc.adm.requests.ListVulnerabilityAuditsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.adm.requests.ListWorkRequestsRequest;
import com.oracle.bmc.adm.requests.UpdateKnowledgeBaseRequest;
import com.oracle.bmc.adm.requests.UpdateRemediationRecipeRequest;
import com.oracle.bmc.adm.requests.UpdateRemediationRunRequest;
import com.oracle.bmc.adm.requests.UpdateVulnerabilityAuditRequest;
import com.oracle.bmc.adm.responses.ActivateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.CancelRemediationRunResponse;
import com.oracle.bmc.adm.responses.CancelWorkRequestResponse;
import com.oracle.bmc.adm.responses.ChangeKnowledgeBaseCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeRemediationRecipeCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeRemediationRunCompartmentResponse;
import com.oracle.bmc.adm.responses.ChangeVulnerabilityAuditCompartmentResponse;
import com.oracle.bmc.adm.responses.CreateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.CreateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.CreateRemediationRunResponse;
import com.oracle.bmc.adm.responses.CreateVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.DeactivateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.DeleteKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.DeleteRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.DeleteRemediationRunResponse;
import com.oracle.bmc.adm.responses.DeleteVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.GetRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.GetRemediationRunResponse;
import com.oracle.bmc.adm.responses.GetStageResponse;
import com.oracle.bmc.adm.responses.GetVulnerabilityAuditResponse;
import com.oracle.bmc.adm.responses.GetWorkRequestResponse;
import com.oracle.bmc.adm.responses.ListApplicationDependencyRecommendationsResponse;
import com.oracle.bmc.adm.responses.ListApplicationDependencyVulnerabilitiesResponse;
import com.oracle.bmc.adm.responses.ListKnowledgeBasesResponse;
import com.oracle.bmc.adm.responses.ListRemediationRecipesResponse;
import com.oracle.bmc.adm.responses.ListRemediationRunsResponse;
import com.oracle.bmc.adm.responses.ListStagesResponse;
import com.oracle.bmc.adm.responses.ListVulnerabilityAuditsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.adm.responses.ListWorkRequestsResponse;
import com.oracle.bmc.adm.responses.UpdateKnowledgeBaseResponse;
import com.oracle.bmc.adm.responses.UpdateRemediationRecipeResponse;
import com.oracle.bmc.adm.responses.UpdateRemediationRunResponse;
import com.oracle.bmc.adm.responses.UpdateVulnerabilityAuditResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationDependencyManagementClient
extends BaseSyncClient
implements ApplicationDependencyManagement {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("APPLICATIONDEPENDENCYMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://adm.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDependencyManagementClient.class);
    private final ApplicationDependencyManagementWaiters waiters;
    private final ApplicationDependencyManagementPaginators paginators;

    ApplicationDependencyManagementClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("ApplicationDependencyManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new ApplicationDependencyManagementWaiters(executorService, this);
        this.paginators = new ApplicationDependencyManagementPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ActivateRemediationRecipeResponse activateRemediationRecipe(ActivateRemediationRecipeRequest request) {
        Validate.notBlank((String)request.getRemediationRecipeId(), (String)"remediationRecipeId must not be blank", (Object[])new Object[0]);
        return (ActivateRemediationRecipeResponse)this.clientCall(request, ActivateRemediationRecipeResponse::builder).logger(LOG, "activateRemediationRecipe").serviceDetails("ApplicationDependencyManagement", "ActivateRemediationRecipe", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/ActivateRemediationRecipe").method(Method.POST).requestBuilder(ActivateRemediationRecipeRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").appendPathParam(request.getRemediationRecipeId()).appendPathParam("actions").appendPathParam("activate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", ActivateRemediationRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ActivateRemediationRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelRemediationRunResponse cancelRemediationRun(CancelRemediationRunRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        return (CancelRemediationRunResponse)this.clientCall(request, CancelRemediationRunResponse::builder).logger(LOG, "cancelRemediationRun").serviceDetails("ApplicationDependencyManagement", "CancelRemediationRun", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/CancelRemediationRun").method(Method.POST).requestBuilder(CancelRemediationRunRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleBody(RemediationRun.class, CancelRemediationRunResponse.Builder::remediationRun).handleResponseHeaderString("opc-request-id", CancelRemediationRunResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CancelRemediationRunResponse.Builder::etag).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("ApplicationDependencyManagement", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeKnowledgeBaseCompartmentResponse changeKnowledgeBaseCompartment(ChangeKnowledgeBaseCompartmentRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeKnowledgeBaseCompartmentDetails(), "changeKnowledgeBaseCompartmentDetails is required");
        return (ChangeKnowledgeBaseCompartmentResponse)this.clientCall(request, ChangeKnowledgeBaseCompartmentResponse::builder).logger(LOG, "changeKnowledgeBaseCompartment").serviceDetails("ApplicationDependencyManagement", "ChangeKnowledgeBaseCompartment", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/ChangeKnowledgeBaseCompartment").method(Method.POST).requestBuilder(ChangeKnowledgeBaseCompartmentRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeKnowledgeBaseCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeKnowledgeBaseCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeRemediationRecipeCompartmentResponse changeRemediationRecipeCompartment(ChangeRemediationRecipeCompartmentRequest request) {
        Validate.notBlank((String)request.getRemediationRecipeId(), (String)"remediationRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRemediationRecipeCompartmentDetails(), "changeRemediationRecipeCompartmentDetails is required");
        return (ChangeRemediationRecipeCompartmentResponse)this.clientCall(request, ChangeRemediationRecipeCompartmentResponse::builder).logger(LOG, "changeRemediationRecipeCompartment").serviceDetails("ApplicationDependencyManagement", "ChangeRemediationRecipeCompartment", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/ChangeRemediationRecipeCompartment").method(Method.POST).requestBuilder(ChangeRemediationRecipeCompartmentRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").appendPathParam(request.getRemediationRecipeId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeRemediationRecipeCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeRemediationRecipeCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeRemediationRunCompartmentResponse changeRemediationRunCompartment(ChangeRemediationRunCompartmentRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeRemediationRunCompartmentDetails(), "changeRemediationRunCompartmentDetails is required");
        return (ChangeRemediationRunCompartmentResponse)this.clientCall(request, ChangeRemediationRunCompartmentResponse::builder).logger(LOG, "changeRemediationRunCompartment").serviceDetails("ApplicationDependencyManagement", "ChangeRemediationRunCompartment", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/ChangeRemediationRunCompartment").method(Method.POST).requestBuilder(ChangeRemediationRunCompartmentRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeRemediationRunCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeVulnerabilityAuditCompartmentResponse changeVulnerabilityAuditCompartment(ChangeVulnerabilityAuditCompartmentRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeVulnerabilityAuditCompartmentDetails(), "changeVulnerabilityAuditCompartmentDetails is required");
        return (ChangeVulnerabilityAuditCompartmentResponse)this.clientCall(request, ChangeVulnerabilityAuditCompartmentResponse::builder).logger(LOG, "changeVulnerabilityAuditCompartment").serviceDetails("ApplicationDependencyManagement", "ChangeVulnerabilityAuditCompartment", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/ChangeVulnerabilityAuditCompartment").method(Method.POST).requestBuilder(ChangeVulnerabilityAuditCompartmentRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeVulnerabilityAuditCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateKnowledgeBaseResponse createKnowledgeBase(CreateKnowledgeBaseRequest request) {
        Objects.requireNonNull(request.getCreateKnowledgeBaseDetails(), "createKnowledgeBaseDetails is required");
        return (CreateKnowledgeBaseResponse)this.clientCall(request, CreateKnowledgeBaseResponse::builder).logger(LOG, "createKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "CreateKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/CreateKnowledgeBase").method(Method.POST).requestBuilder(CreateKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateKnowledgeBaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRemediationRecipeResponse createRemediationRecipe(CreateRemediationRecipeRequest request) {
        Objects.requireNonNull(request.getCreateRemediationRecipeDetails(), "createRemediationRecipeDetails is required");
        return (CreateRemediationRecipeResponse)this.clientCall(request, CreateRemediationRecipeResponse::builder).logger(LOG, "createRemediationRecipe").serviceDetails("ApplicationDependencyManagement", "CreateRemediationRecipe", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/CreateRemediationRecipe").method(Method.POST).requestBuilder(CreateRemediationRecipeRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateRemediationRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRemediationRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateRemediationRunResponse createRemediationRun(CreateRemediationRunRequest request) {
        Objects.requireNonNull(request.getCreateRemediationRunDetails(), "createRemediationRunDetails is required");
        return (CreateRemediationRunResponse)this.clientCall(request, CreateRemediationRunResponse::builder).logger(LOG, "createRemediationRun").serviceDetails("ApplicationDependencyManagement", "CreateRemediationRun", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/CreateRemediationRun").method(Method.POST).requestBuilder(CreateRemediationRunRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(RemediationRun.class, CreateRemediationRunResponse.Builder::remediationRun).handleResponseHeaderString("etag", CreateRemediationRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRemediationRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateVulnerabilityAuditResponse createVulnerabilityAudit(CreateVulnerabilityAuditRequest request) {
        Objects.requireNonNull(request.getCreateVulnerabilityAuditDetails(), "createVulnerabilityAuditDetails is required");
        return (CreateVulnerabilityAuditResponse)this.clientCall(request, CreateVulnerabilityAuditResponse::builder).logger(LOG, "createVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "CreateVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/CreateVulnerabilityAudit").method(Method.POST).requestBuilder(CreateVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(VulnerabilityAudit.class, CreateVulnerabilityAuditResponse.Builder::vulnerabilityAudit).handleResponseHeaderString("etag", CreateVulnerabilityAuditResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateVulnerabilityAuditResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeactivateRemediationRecipeResponse deactivateRemediationRecipe(DeactivateRemediationRecipeRequest request) {
        Validate.notBlank((String)request.getRemediationRecipeId(), (String)"remediationRecipeId must not be blank", (Object[])new Object[0]);
        return (DeactivateRemediationRecipeResponse)this.clientCall(request, DeactivateRemediationRecipeResponse::builder).logger(LOG, "deactivateRemediationRecipe").serviceDetails("ApplicationDependencyManagement", "DeactivateRemediationRecipe", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/DeactivateRemediationRecipe").method(Method.POST).requestBuilder(DeactivateRemediationRecipeRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").appendPathParam(request.getRemediationRecipeId()).appendPathParam("actions").appendPathParam("deactivate").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeactivateRemediationRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeactivateRemediationRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteKnowledgeBaseResponse deleteKnowledgeBase(DeleteKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        return (DeleteKnowledgeBaseResponse)this.clientCall(request, DeleteKnowledgeBaseResponse::builder).logger(LOG, "deleteKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "DeleteKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/DeleteKnowledgeBase").method(Method.DELETE).requestBuilder(DeleteKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteKnowledgeBaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRemediationRecipeResponse deleteRemediationRecipe(DeleteRemediationRecipeRequest request) {
        Validate.notBlank((String)request.getRemediationRecipeId(), (String)"remediationRecipeId must not be blank", (Object[])new Object[0]);
        return (DeleteRemediationRecipeResponse)this.clientCall(request, DeleteRemediationRecipeResponse::builder).logger(LOG, "deleteRemediationRecipe").serviceDetails("ApplicationDependencyManagement", "DeleteRemediationRecipe", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/DeleteRemediationRecipe").method(Method.DELETE).requestBuilder(DeleteRemediationRecipeRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").appendPathParam(request.getRemediationRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteRemediationRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRemediationRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRemediationRunResponse deleteRemediationRun(DeleteRemediationRunRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        return (DeleteRemediationRunResponse)this.clientCall(request, DeleteRemediationRunResponse::builder).logger(LOG, "deleteRemediationRun").serviceDetails("ApplicationDependencyManagement", "DeleteRemediationRun", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/DeleteRemediationRun").method(Method.DELETE).requestBuilder(DeleteRemediationRunRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteRemediationRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteVulnerabilityAuditResponse deleteVulnerabilityAudit(DeleteVulnerabilityAuditRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        return (DeleteVulnerabilityAuditResponse)this.clientCall(request, DeleteVulnerabilityAuditResponse::builder).logger(LOG, "deleteVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "DeleteVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/DeleteVulnerabilityAudit").method(Method.DELETE).requestBuilder(DeleteVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteVulnerabilityAuditResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetKnowledgeBaseResponse getKnowledgeBase(GetKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        return (GetKnowledgeBaseResponse)this.clientCall(request, GetKnowledgeBaseResponse::builder).logger(LOG, "getKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "GetKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/GetKnowledgeBase").method(Method.GET).requestBuilder(GetKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(KnowledgeBase.class, GetKnowledgeBaseResponse.Builder::knowledgeBase).handleResponseHeaderString("opc-request-id", GetKnowledgeBaseResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetKnowledgeBaseResponse.Builder::etag).callSync();
    }

    @Override
    public GetRemediationRecipeResponse getRemediationRecipe(GetRemediationRecipeRequest request) {
        Validate.notBlank((String)request.getRemediationRecipeId(), (String)"remediationRecipeId must not be blank", (Object[])new Object[0]);
        return (GetRemediationRecipeResponse)this.clientCall(request, GetRemediationRecipeResponse::builder).logger(LOG, "getRemediationRecipe").serviceDetails("ApplicationDependencyManagement", "GetRemediationRecipe", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/GetRemediationRecipe").method(Method.GET).requestBuilder(GetRemediationRecipeRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").appendPathParam(request.getRemediationRecipeId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RemediationRecipe.class, GetRemediationRecipeResponse.Builder::remediationRecipe).handleResponseHeaderString("opc-request-id", GetRemediationRecipeResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRemediationRecipeResponse.Builder::etag).callSync();
    }

    @Override
    public GetRemediationRunResponse getRemediationRun(GetRemediationRunRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        return (GetRemediationRunResponse)this.clientCall(request, GetRemediationRunResponse::builder).logger(LOG, "getRemediationRun").serviceDetails("ApplicationDependencyManagement", "GetRemediationRun", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/GetRemediationRun").method(Method.GET).requestBuilder(GetRemediationRunRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RemediationRun.class, GetRemediationRunResponse.Builder::remediationRun).handleResponseHeaderString("opc-request-id", GetRemediationRunResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRemediationRunResponse.Builder::etag).callSync();
    }

    @Override
    public GetStageResponse getStage(GetStageRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getStageType().getValue(), (String)"stageType must not be blank", (Object[])new Object[0]);
        return (GetStageResponse)this.clientCall(request, GetStageResponse::builder).logger(LOG, "getStage").serviceDetails("ApplicationDependencyManagement", "GetStage", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRunStage/GetStage").method(Method.GET).requestBuilder(GetStageRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).appendPathParam("stages").appendPathParam(request.getStageType().getValue()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RemediationRunStage.class, GetStageResponse.Builder::remediationRunStage).handleResponseHeaderString("opc-request-id", GetStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetVulnerabilityAuditResponse getVulnerabilityAudit(GetVulnerabilityAuditRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        return (GetVulnerabilityAuditResponse)this.clientCall(request, GetVulnerabilityAuditResponse::builder).logger(LOG, "getVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "GetVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/GetVulnerabilityAudit").method(Method.GET).requestBuilder(GetVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VulnerabilityAudit.class, GetVulnerabilityAuditResponse.Builder::vulnerabilityAudit).handleResponseHeaderString("etag", GetVulnerabilityAuditResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVulnerabilityAuditResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("ApplicationDependencyManagement", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListApplicationDependencyRecommendationsResponse listApplicationDependencyRecommendations(ListApplicationDependencyRecommendationsRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        return (ListApplicationDependencyRecommendationsResponse)this.clientCall(request, ListApplicationDependencyRecommendationsResponse::builder).logger(LOG, "listApplicationDependencyRecommendations").serviceDetails("ApplicationDependencyManagement", "ListApplicationDependencyRecommendations", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/ListApplicationDependencyRecommendations").method(Method.GET).requestBuilder(ListApplicationDependencyRecommendationsRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).appendPathParam("applicationDependencyRecommendations").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("gav", (Object)request.getGav()).appendQueryParam("purl", (Object)request.getPurl()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ApplicationDependencyRecommendationCollection.class, ListApplicationDependencyRecommendationsResponse.Builder::applicationDependencyRecommendationCollection).handleResponseHeaderString("opc-request-id", ListApplicationDependencyRecommendationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApplicationDependencyRecommendationsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListApplicationDependencyVulnerabilitiesResponse listApplicationDependencyVulnerabilities(ListApplicationDependencyVulnerabilitiesRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        return (ListApplicationDependencyVulnerabilitiesResponse)this.clientCall(request, ListApplicationDependencyVulnerabilitiesResponse::builder).logger(LOG, "listApplicationDependencyVulnerabilities").serviceDetails("ApplicationDependencyManagement", "ListApplicationDependencyVulnerabilities", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/ListApplicationDependencyVulnerabilities").method(Method.GET).requestBuilder(ListApplicationDependencyVulnerabilitiesRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).appendPathParam("applicationDependencyVulnerabilities").appendQueryParam("vulnerabilityId", (Object)request.getVulnerabilityId()).appendQueryParam("cvssV3GreaterThanOrEqual", (Object)request.getCvssV3GreaterThanOrEqual()).appendQueryParam("cvssV2GreaterThanOrEqual", (Object)request.getCvssV2GreaterThanOrEqual()).appendEnumQueryParam("severityGreaterThanOrEqual", (BmcEnum)request.getSeverityGreaterThanOrEqual()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("rootNodeId", (Object)request.getRootNodeId()).appendQueryParam("depth", (Object)request.getDepth()).appendQueryParam("gav", (Object)request.getGav()).appendQueryParam("purl", (Object)request.getPurl()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ApplicationDependencyVulnerabilityCollection.class, ListApplicationDependencyVulnerabilitiesResponse.Builder::applicationDependencyVulnerabilityCollection).handleResponseHeaderString("opc-request-id", ListApplicationDependencyVulnerabilitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListApplicationDependencyVulnerabilitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListKnowledgeBasesResponse listKnowledgeBases(ListKnowledgeBasesRequest request) {
        return (ListKnowledgeBasesResponse)this.clientCall(request, ListKnowledgeBasesResponse::builder).logger(LOG, "listKnowledgeBases").serviceDetails("ApplicationDependencyManagement", "ListKnowledgeBases", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/ListKnowledgeBases").method(Method.GET).requestBuilder(ListKnowledgeBasesRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(KnowledgeBaseCollection.class, ListKnowledgeBasesResponse.Builder::knowledgeBaseCollection).handleResponseHeaderString("opc-request-id", ListKnowledgeBasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListKnowledgeBasesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRemediationRecipesResponse listRemediationRecipes(ListRemediationRecipesRequest request) {
        return (ListRemediationRecipesResponse)this.clientCall(request, ListRemediationRecipesResponse::builder).logger(LOG, "listRemediationRecipes").serviceDetails("ApplicationDependencyManagement", "ListRemediationRecipes", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/ListRemediationRecipes").method(Method.GET).requestBuilder(ListRemediationRecipesRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RemediationRecipeCollection.class, ListRemediationRecipesResponse.Builder::remediationRecipeCollection).handleResponseHeaderString("opc-request-id", ListRemediationRecipesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRemediationRecipesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRemediationRunsResponse listRemediationRuns(ListRemediationRunsRequest request) {
        return (ListRemediationRunsResponse)this.clientCall(request, ListRemediationRunsResponse::builder).logger(LOG, "listRemediationRuns").serviceDetails("ApplicationDependencyManagement", "ListRemediationRuns", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/ListRemediationRuns").method(Method.GET).requestBuilder(ListRemediationRunsRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendQueryParam("id", (Object)request.getId()).appendQueryParam("remediationRecipeId", (Object)request.getRemediationRecipeId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RemediationRunCollection.class, ListRemediationRunsResponse.Builder::remediationRunCollection).handleResponseHeaderString("opc-request-id", ListRemediationRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRemediationRunsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListStagesResponse listStages(ListStagesRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        return (ListStagesResponse)this.clientCall(request, ListStagesResponse::builder).logger(LOG, "listStages").serviceDetails("ApplicationDependencyManagement", "ListStages", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRunStage/ListStages").method(Method.GET).requestBuilder(ListStagesRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).appendPathParam("stages").appendEnumQueryParam("type", (BmcEnum)request.getType()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RemediationRunStageCollection.class, ListStagesResponse.Builder::remediationRunStageCollection).handleResponseHeaderString("opc-request-id", ListStagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListStagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListVulnerabilityAuditsResponse listVulnerabilityAudits(ListVulnerabilityAuditsRequest request) {
        return (ListVulnerabilityAuditsResponse)this.clientCall(request, ListVulnerabilityAuditsResponse::builder).logger(LOG, "listVulnerabilityAudits").serviceDetails("ApplicationDependencyManagement", "ListVulnerabilityAudits", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/ListVulnerabilityAudits").method(Method.GET).requestBuilder(ListVulnerabilityAuditsRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("knowledgeBaseId", (Object)request.getKnowledgeBaseId()).appendQueryParam("isSuccess", (Object)request.getIsSuccess()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThanOrEqualTo", (Object)request.getTimeCreatedLessThanOrEqualTo()).appendEnumQueryParam("maxObservedSeverityGreaterThanOrEqualTo", (BmcEnum)request.getMaxObservedSeverityGreaterThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(VulnerabilityAuditCollection.class, ListVulnerabilityAuditsResponse.Builder::vulnerabilityAuditCollection).handleResponseHeaderString("opc-request-id", ListVulnerabilityAuditsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListVulnerabilityAuditsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("ApplicationDependencyManagement", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("ApplicationDependencyManagement", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("ApplicationDependencyManagement", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220421").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public UpdateKnowledgeBaseResponse updateKnowledgeBase(UpdateKnowledgeBaseRequest request) {
        Validate.notBlank((String)request.getKnowledgeBaseId(), (String)"knowledgeBaseId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateKnowledgeBaseDetails(), "updateKnowledgeBaseDetails is required");
        return (UpdateKnowledgeBaseResponse)this.clientCall(request, UpdateKnowledgeBaseResponse::builder).logger(LOG, "updateKnowledgeBase").serviceDetails("ApplicationDependencyManagement", "UpdateKnowledgeBase", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/KnowledgeBase/UpdateKnowledgeBase").method(Method.PUT).requestBuilder(UpdateKnowledgeBaseRequest::builder).basePath("/20220421").appendPathParam("knowledgeBases").appendPathParam(request.getKnowledgeBaseId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateKnowledgeBaseResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateKnowledgeBaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRemediationRecipeResponse updateRemediationRecipe(UpdateRemediationRecipeRequest request) {
        Validate.notBlank((String)request.getRemediationRecipeId(), (String)"remediationRecipeId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRemediationRecipeDetails(), "updateRemediationRecipeDetails is required");
        return (UpdateRemediationRecipeResponse)this.clientCall(request, UpdateRemediationRecipeResponse::builder).logger(LOG, "updateRemediationRecipe").serviceDetails("ApplicationDependencyManagement", "UpdateRemediationRecipe", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRecipe/UpdateRemediationRecipe").method(Method.PUT).requestBuilder(UpdateRemediationRecipeRequest::builder).basePath("/20220421").appendPathParam("remediationRecipes").appendPathParam(request.getRemediationRecipeId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateRemediationRecipeResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRemediationRecipeResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRemediationRunResponse updateRemediationRun(UpdateRemediationRunRequest request) {
        Validate.notBlank((String)request.getRemediationRunId(), (String)"remediationRunId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRemediationRunDetails(), "updateRemediationRunDetails is required");
        return (UpdateRemediationRunResponse)this.clientCall(request, UpdateRemediationRunResponse::builder).logger(LOG, "updateRemediationRun").serviceDetails("ApplicationDependencyManagement", "UpdateRemediationRun", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/RemediationRun/UpdateRemediationRun").method(Method.PUT).requestBuilder(UpdateRemediationRunRequest::builder).basePath("/20220421").appendPathParam("remediationRuns").appendPathParam(request.getRemediationRunId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RemediationRun.class, UpdateRemediationRunResponse.Builder::remediationRun).handleResponseHeaderString("etag", UpdateRemediationRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRemediationRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateVulnerabilityAuditResponse updateVulnerabilityAudit(UpdateVulnerabilityAuditRequest request) {
        Validate.notBlank((String)request.getVulnerabilityAuditId(), (String)"vulnerabilityAuditId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVulnerabilityAuditDetails(), "updateVulnerabilityAuditDetails is required");
        return (UpdateVulnerabilityAuditResponse)this.clientCall(request, UpdateVulnerabilityAuditResponse::builder).logger(LOG, "updateVulnerabilityAudit").serviceDetails("ApplicationDependencyManagement", "UpdateVulnerabilityAudit", "https://docs.oracle.com/iaas/api/#/en/adm/20220421/VulnerabilityAudit/UpdateVulnerabilityAudit").method(Method.PUT).requestBuilder(UpdateVulnerabilityAuditRequest::builder).basePath("/20220421").appendPathParam("vulnerabilityAudits").appendPathParam(request.getVulnerabilityAuditId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(VulnerabilityAudit.class, UpdateVulnerabilityAuditResponse.Builder::vulnerabilityAudit).handleResponseHeaderString("etag", UpdateVulnerabilityAuditResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVulnerabilityAuditResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ApplicationDependencyManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public ApplicationDependencyManagementPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public ApplicationDependencyManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ApplicationDependencyManagementClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ApplicationDependencyManagementClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public ApplicationDependencyManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ApplicationDependencyManagementClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ApplicationDependencyManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "adm";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"adm");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public ApplicationDependencyManagementClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ApplicationDependencyManagementClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

