/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.ScmConfiguration;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="scmType")
@JsonFilter(value="explicitlySetFilter")
public final class ExternalScmConfiguration
extends ScmConfiguration {
    @JsonProperty(value="externalScmType")
    private final ExternalScmType externalScmType;
    @JsonProperty(value="repositoryUrl")
    private final String repositoryUrl;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="patSecretId")
    private final String patSecretId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExternalScmConfiguration(String branch, String buildFileLocation, Boolean isAutomergeEnabled, ExternalScmType externalScmType, String repositoryUrl, String username, String patSecretId) {
        super(branch, buildFileLocation, isAutomergeEnabled);
        this.externalScmType = externalScmType;
        this.repositoryUrl = repositoryUrl;
        this.username = username;
        this.patSecretId = patSecretId;
    }

    public ExternalScmType getExternalScmType() {
        return this.externalScmType;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPatSecretId() {
        return this.patSecretId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExternalScmConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", externalScmType=").append(String.valueOf((Object)this.externalScmType));
        sb.append(", repositoryUrl=").append(String.valueOf(this.repositoryUrl));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", patSecretId=").append(String.valueOf(this.patSecretId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExternalScmConfiguration)) {
            return false;
        }
        ExternalScmConfiguration other = (ExternalScmConfiguration)((Object)o);
        return Objects.equals((Object)this.externalScmType, (Object)other.externalScmType) && Objects.equals(this.repositoryUrl, other.repositoryUrl) && Objects.equals(this.username, other.username) && Objects.equals(this.patSecretId, other.patSecretId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.externalScmType == null ? 43 : this.externalScmType.hashCode());
        result = result * 59 + (this.repositoryUrl == null ? 43 : this.repositoryUrl.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.patSecretId == null ? 43 : this.patSecretId.hashCode());
        return result;
    }

    public static enum ExternalScmType implements BmcEnum
    {
        Github("GITHUB"),
        Gitlab("GITLAB"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExternalScmType> map;

        private ExternalScmType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExternalScmType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExternalScmType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExternalScmType.class);
            map = new HashMap<String, ExternalScmType>();
            for (ExternalScmType v : ExternalScmType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="branch")
        private String branch;
        @JsonProperty(value="buildFileLocation")
        private String buildFileLocation;
        @JsonProperty(value="isAutomergeEnabled")
        private Boolean isAutomergeEnabled;
        @JsonProperty(value="externalScmType")
        private ExternalScmType externalScmType;
        @JsonProperty(value="repositoryUrl")
        private String repositoryUrl;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="patSecretId")
        private String patSecretId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder branch(String branch) {
            this.branch = branch;
            this.__explicitlySet__.add("branch");
            return this;
        }

        public Builder buildFileLocation(String buildFileLocation) {
            this.buildFileLocation = buildFileLocation;
            this.__explicitlySet__.add("buildFileLocation");
            return this;
        }

        public Builder isAutomergeEnabled(Boolean isAutomergeEnabled) {
            this.isAutomergeEnabled = isAutomergeEnabled;
            this.__explicitlySet__.add("isAutomergeEnabled");
            return this;
        }

        public Builder externalScmType(ExternalScmType externalScmType) {
            this.externalScmType = externalScmType;
            this.__explicitlySet__.add("externalScmType");
            return this;
        }

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            this.__explicitlySet__.add("repositoryUrl");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder patSecretId(String patSecretId) {
            this.patSecretId = patSecretId;
            this.__explicitlySet__.add("patSecretId");
            return this;
        }

        public ExternalScmConfiguration build() {
            ExternalScmConfiguration model = new ExternalScmConfiguration(this.branch, this.buildFileLocation, this.isAutomergeEnabled, this.externalScmType, this.repositoryUrl, this.username, this.patSecretId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExternalScmConfiguration model) {
            if (model.wasPropertyExplicitlySet("branch")) {
                this.branch(model.getBranch());
            }
            if (model.wasPropertyExplicitlySet("buildFileLocation")) {
                this.buildFileLocation(model.getBuildFileLocation());
            }
            if (model.wasPropertyExplicitlySet("isAutomergeEnabled")) {
                this.isAutomergeEnabled(model.getIsAutomergeEnabled());
            }
            if (model.wasPropertyExplicitlySet("externalScmType")) {
                this.externalScmType(model.getExternalScmType());
            }
            if (model.wasPropertyExplicitlySet("repositoryUrl")) {
                this.repositoryUrl(model.getRepositoryUrl());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("patSecretId")) {
                this.patSecretId(model.getPatSecretId());
            }
            return this;
        }
    }
}

