/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.VerifyConfiguration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="buildServiceType")
@JsonFilter(value="explicitlySetFilter")
public final class GitHubActionsConfiguration
extends VerifyConfiguration {
    @JsonProperty(value="repositoryUrl")
    private final String repositoryUrl;
    @JsonProperty(value="patSecretId")
    private final String patSecretId;
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="workflowName")
    private final String workflowName;
    @JsonProperty(value="additionalParameters")
    private final Map<String, String> additionalParameters;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GitHubActionsConfiguration(String repositoryUrl, String patSecretId, String username, String workflowName, Map<String, String> additionalParameters) {
        this.repositoryUrl = repositoryUrl;
        this.patSecretId = patSecretId;
        this.username = username;
        this.workflowName = workflowName;
        this.additionalParameters = additionalParameters;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getPatSecretId() {
        return this.patSecretId;
    }

    public String getUsername() {
        return this.username;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public Map<String, String> getAdditionalParameters() {
        return this.additionalParameters;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GitHubActionsConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", repositoryUrl=").append(String.valueOf(this.repositoryUrl));
        sb.append(", patSecretId=").append(String.valueOf(this.patSecretId));
        sb.append(", username=").append(String.valueOf(this.username));
        sb.append(", workflowName=").append(String.valueOf(this.workflowName));
        sb.append(", additionalParameters=").append(String.valueOf(this.additionalParameters));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitHubActionsConfiguration)) {
            return false;
        }
        GitHubActionsConfiguration other = (GitHubActionsConfiguration)((Object)o);
        return Objects.equals(this.repositoryUrl, other.repositoryUrl) && Objects.equals(this.patSecretId, other.patSecretId) && Objects.equals(this.username, other.username) && Objects.equals(this.workflowName, other.workflowName) && Objects.equals(this.additionalParameters, other.additionalParameters) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryUrl == null ? 43 : this.repositoryUrl.hashCode());
        result = result * 59 + (this.patSecretId == null ? 43 : this.patSecretId.hashCode());
        result = result * 59 + (this.username == null ? 43 : this.username.hashCode());
        result = result * 59 + (this.workflowName == null ? 43 : this.workflowName.hashCode());
        result = result * 59 + (this.additionalParameters == null ? 43 : this.additionalParameters.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="repositoryUrl")
        private String repositoryUrl;
        @JsonProperty(value="patSecretId")
        private String patSecretId;
        @JsonProperty(value="username")
        private String username;
        @JsonProperty(value="workflowName")
        private String workflowName;
        @JsonProperty(value="additionalParameters")
        private Map<String, String> additionalParameters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            this.__explicitlySet__.add("repositoryUrl");
            return this;
        }

        public Builder patSecretId(String patSecretId) {
            this.patSecretId = patSecretId;
            this.__explicitlySet__.add("patSecretId");
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            this.__explicitlySet__.add("username");
            return this;
        }

        public Builder workflowName(String workflowName) {
            this.workflowName = workflowName;
            this.__explicitlySet__.add("workflowName");
            return this;
        }

        public Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = additionalParameters;
            this.__explicitlySet__.add("additionalParameters");
            return this;
        }

        public GitHubActionsConfiguration build() {
            GitHubActionsConfiguration model = new GitHubActionsConfiguration(this.repositoryUrl, this.patSecretId, this.username, this.workflowName, this.additionalParameters);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GitHubActionsConfiguration model) {
            if (model.wasPropertyExplicitlySet("repositoryUrl")) {
                this.repositoryUrl(model.getRepositoryUrl());
            }
            if (model.wasPropertyExplicitlySet("patSecretId")) {
                this.patSecretId(model.getPatSecretId());
            }
            if (model.wasPropertyExplicitlySet("username")) {
                this.username(model.getUsername());
            }
            if (model.wasPropertyExplicitlySet("workflowName")) {
                this.workflowName(model.getWorkflowName());
            }
            if (model.wasPropertyExplicitlySet("additionalParameters")) {
                this.additionalParameters(model.getAdditionalParameters());
            }
            return this;
        }
    }
}

