/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.adm.model.ScmConfiguration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="scmType")
@JsonFilter(value="explicitlySetFilter")
public final class OciCodeRepositoryConfiguration
extends ScmConfiguration {
    @JsonProperty(value="ociCodeRepositoryId")
    private final String ociCodeRepositoryId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public OciCodeRepositoryConfiguration(String branch, String buildFileLocation, Boolean isAutomergeEnabled, String ociCodeRepositoryId) {
        super(branch, buildFileLocation, isAutomergeEnabled);
        this.ociCodeRepositoryId = ociCodeRepositoryId;
    }

    public String getOciCodeRepositoryId() {
        return this.ociCodeRepositoryId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OciCodeRepositoryConfiguration(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", ociCodeRepositoryId=").append(String.valueOf(this.ociCodeRepositoryId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OciCodeRepositoryConfiguration)) {
            return false;
        }
        OciCodeRepositoryConfiguration other = (OciCodeRepositoryConfiguration)((Object)o);
        return Objects.equals(this.ociCodeRepositoryId, other.ociCodeRepositoryId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ociCodeRepositoryId == null ? 43 : this.ociCodeRepositoryId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="branch")
        private String branch;
        @JsonProperty(value="buildFileLocation")
        private String buildFileLocation;
        @JsonProperty(value="isAutomergeEnabled")
        private Boolean isAutomergeEnabled;
        @JsonProperty(value="ociCodeRepositoryId")
        private String ociCodeRepositoryId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder branch(String branch) {
            this.branch = branch;
            this.__explicitlySet__.add("branch");
            return this;
        }

        public Builder buildFileLocation(String buildFileLocation) {
            this.buildFileLocation = buildFileLocation;
            this.__explicitlySet__.add("buildFileLocation");
            return this;
        }

        public Builder isAutomergeEnabled(Boolean isAutomergeEnabled) {
            this.isAutomergeEnabled = isAutomergeEnabled;
            this.__explicitlySet__.add("isAutomergeEnabled");
            return this;
        }

        public Builder ociCodeRepositoryId(String ociCodeRepositoryId) {
            this.ociCodeRepositoryId = ociCodeRepositoryId;
            this.__explicitlySet__.add("ociCodeRepositoryId");
            return this;
        }

        public OciCodeRepositoryConfiguration build() {
            OciCodeRepositoryConfiguration model = new OciCodeRepositoryConfiguration(this.branch, this.buildFileLocation, this.isAutomergeEnabled, this.ociCodeRepositoryId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OciCodeRepositoryConfiguration model) {
            if (model.wasPropertyExplicitlySet("branch")) {
                this.branch(model.getBranch());
            }
            if (model.wasPropertyExplicitlySet("buildFileLocation")) {
                this.buildFileLocation(model.getBuildFileLocation());
            }
            if (model.wasPropertyExplicitlySet("isAutomergeEnabled")) {
                this.isAutomergeEnabled(model.getIsAutomergeEnabled());
            }
            if (model.wasPropertyExplicitlySet("ociCodeRepositoryId")) {
                this.ociCodeRepositoryId(model.getOciCodeRepositoryId());
            }
            return this;
        }
    }
}

