/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRemediationRecipeRequest
extends BmcRequest<Void> {
    private String remediationRecipeId;
    private String opcRequestId;

    public String getRemediationRecipeId() {
        return this.remediationRecipeId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().remediationRecipeId(this.remediationRecipeId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",remediationRecipeId=").append(String.valueOf(this.remediationRecipeId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRemediationRecipeRequest)) {
            return false;
        }
        GetRemediationRecipeRequest other = (GetRemediationRecipeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.remediationRecipeId, other.remediationRecipeId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.remediationRecipeId == null ? 43 : this.remediationRecipeId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRemediationRecipeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String remediationRecipeId = null;
        private String opcRequestId = null;

        public Builder remediationRecipeId(String remediationRecipeId) {
            this.remediationRecipeId = remediationRecipeId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRemediationRecipeRequest o) {
            this.remediationRecipeId(o.getRemediationRecipeId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRemediationRecipeRequest build() {
            GetRemediationRecipeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRemediationRecipeRequest buildWithoutInvocationCallback() {
            GetRemediationRecipeRequest request = new GetRemediationRecipeRequest();
            request.remediationRecipeId = this.remediationRecipeId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

