/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Anomaly
extends ExplicitlySetBmcModel {
    @JsonProperty(value="signalName")
    private final String signalName;
    @JsonProperty(value="actualValue")
    private final Double actualValue;
    @JsonProperty(value="estimatedValue")
    private final Double estimatedValue;
    @JsonProperty(value="imputedValue")
    private final Double imputedValue;
    @JsonProperty(value="anomalyScore")
    private final Double anomalyScore;

    @Deprecated
    @ConstructorProperties(value={"signalName", "actualValue", "estimatedValue", "imputedValue", "anomalyScore"})
    public Anomaly(String signalName, Double actualValue, Double estimatedValue, Double imputedValue, Double anomalyScore) {
        this.signalName = signalName;
        this.actualValue = actualValue;
        this.estimatedValue = estimatedValue;
        this.imputedValue = imputedValue;
        this.anomalyScore = anomalyScore;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSignalName() {
        return this.signalName;
    }

    public Double getActualValue() {
        return this.actualValue;
    }

    public Double getEstimatedValue() {
        return this.estimatedValue;
    }

    public Double getImputedValue() {
        return this.imputedValue;
    }

    public Double getAnomalyScore() {
        return this.anomalyScore;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Anomaly(");
        sb.append("super=").append(super.toString());
        sb.append("signalName=").append(String.valueOf(this.signalName));
        sb.append(", actualValue=").append(String.valueOf(this.actualValue));
        sb.append(", estimatedValue=").append(String.valueOf(this.estimatedValue));
        sb.append(", imputedValue=").append(String.valueOf(this.imputedValue));
        sb.append(", anomalyScore=").append(String.valueOf(this.anomalyScore));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)((Object)o);
        return Objects.equals(this.signalName, other.signalName) && Objects.equals(this.actualValue, other.actualValue) && Objects.equals(this.estimatedValue, other.estimatedValue) && Objects.equals(this.imputedValue, other.imputedValue) && Objects.equals(this.anomalyScore, other.anomalyScore) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.signalName == null ? 43 : this.signalName.hashCode());
        result = result * 59 + (this.actualValue == null ? 43 : this.actualValue.hashCode());
        result = result * 59 + (this.estimatedValue == null ? 43 : this.estimatedValue.hashCode());
        result = result * 59 + (this.imputedValue == null ? 43 : this.imputedValue.hashCode());
        result = result * 59 + (this.anomalyScore == null ? 43 : this.anomalyScore.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="signalName")
        private String signalName;
        @JsonProperty(value="actualValue")
        private Double actualValue;
        @JsonProperty(value="estimatedValue")
        private Double estimatedValue;
        @JsonProperty(value="imputedValue")
        private Double imputedValue;
        @JsonProperty(value="anomalyScore")
        private Double anomalyScore;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder signalName(String signalName) {
            this.signalName = signalName;
            this.__explicitlySet__.add("signalName");
            return this;
        }

        public Builder actualValue(Double actualValue) {
            this.actualValue = actualValue;
            this.__explicitlySet__.add("actualValue");
            return this;
        }

        public Builder estimatedValue(Double estimatedValue) {
            this.estimatedValue = estimatedValue;
            this.__explicitlySet__.add("estimatedValue");
            return this;
        }

        public Builder imputedValue(Double imputedValue) {
            this.imputedValue = imputedValue;
            this.__explicitlySet__.add("imputedValue");
            return this;
        }

        public Builder anomalyScore(Double anomalyScore) {
            this.anomalyScore = anomalyScore;
            this.__explicitlySet__.add("anomalyScore");
            return this;
        }

        public Anomaly build() {
            Anomaly model = new Anomaly(this.signalName, this.actualValue, this.estimatedValue, this.imputedValue, this.anomalyScore);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Anomaly model) {
            if (model.wasPropertyExplicitlySet("signalName")) {
                this.signalName(model.getSignalName());
            }
            if (model.wasPropertyExplicitlySet("actualValue")) {
                this.actualValue(model.getActualValue());
            }
            if (model.wasPropertyExplicitlySet("estimatedValue")) {
                this.estimatedValue(model.getEstimatedValue());
            }
            if (model.wasPropertyExplicitlySet("imputedValue")) {
                this.imputedValue(model.getImputedValue());
            }
            if (model.wasPropertyExplicitlySet("anomalyScore")) {
                this.anomalyScore(model.getAnomalyScore());
            }
            return this;
        }
    }
}

