/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModelTrainingDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="algorithmHint")
    private final AlgorithmHint algorithmHint;
    @JsonProperty(value="targetFap")
    private final Float targetFap;
    @JsonProperty(value="trainingFraction")
    private final Float trainingFraction;
    @JsonProperty(value="windowSize")
    private final Integer windowSize;
    @JsonProperty(value="dataAssetIds")
    private final List<String> dataAssetIds;

    @Deprecated
    @ConstructorProperties(value={"algorithmHint", "targetFap", "trainingFraction", "windowSize", "dataAssetIds"})
    public ModelTrainingDetails(AlgorithmHint algorithmHint, Float targetFap, Float trainingFraction, Integer windowSize, List<String> dataAssetIds) {
        this.algorithmHint = algorithmHint;
        this.targetFap = targetFap;
        this.trainingFraction = trainingFraction;
        this.windowSize = windowSize;
        this.dataAssetIds = dataAssetIds;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public AlgorithmHint getAlgorithmHint() {
        return this.algorithmHint;
    }

    public Float getTargetFap() {
        return this.targetFap;
    }

    public Float getTrainingFraction() {
        return this.trainingFraction;
    }

    public Integer getWindowSize() {
        return this.windowSize;
    }

    public List<String> getDataAssetIds() {
        return this.dataAssetIds;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelTrainingDetails(");
        sb.append("super=").append(super.toString());
        sb.append("algorithmHint=").append(String.valueOf((Object)this.algorithmHint));
        sb.append(", targetFap=").append(String.valueOf(this.targetFap));
        sb.append(", trainingFraction=").append(String.valueOf(this.trainingFraction));
        sb.append(", windowSize=").append(String.valueOf(this.windowSize));
        sb.append(", dataAssetIds=").append(String.valueOf(this.dataAssetIds));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelTrainingDetails)) {
            return false;
        }
        ModelTrainingDetails other = (ModelTrainingDetails)((Object)o);
        return Objects.equals((Object)this.algorithmHint, (Object)other.algorithmHint) && Objects.equals(this.targetFap, other.targetFap) && Objects.equals(this.trainingFraction, other.trainingFraction) && Objects.equals(this.windowSize, other.windowSize) && Objects.equals(this.dataAssetIds, other.dataAssetIds) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.algorithmHint == null ? 43 : this.algorithmHint.hashCode());
        result = result * 59 + (this.targetFap == null ? 43 : this.targetFap.hashCode());
        result = result * 59 + (this.trainingFraction == null ? 43 : this.trainingFraction.hashCode());
        result = result * 59 + (this.windowSize == null ? 43 : this.windowSize.hashCode());
        result = result * 59 + (this.dataAssetIds == null ? 43 : this.dataAssetIds.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AlgorithmHint implements BmcEnum
    {
        MultivariateMset("MULTIVARIATE_MSET"),
        UnivariateOcsvm("UNIVARIATE_OCSVM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AlgorithmHint> map;

        private AlgorithmHint(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AlgorithmHint create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AlgorithmHint', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AlgorithmHint.class);
            map = new HashMap<String, AlgorithmHint>();
            for (AlgorithmHint v : AlgorithmHint.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="algorithmHint")
        private AlgorithmHint algorithmHint;
        @JsonProperty(value="targetFap")
        private Float targetFap;
        @JsonProperty(value="trainingFraction")
        private Float trainingFraction;
        @JsonProperty(value="windowSize")
        private Integer windowSize;
        @JsonProperty(value="dataAssetIds")
        private List<String> dataAssetIds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder algorithmHint(AlgorithmHint algorithmHint) {
            this.algorithmHint = algorithmHint;
            this.__explicitlySet__.add("algorithmHint");
            return this;
        }

        public Builder targetFap(Float targetFap) {
            this.targetFap = targetFap;
            this.__explicitlySet__.add("targetFap");
            return this;
        }

        public Builder trainingFraction(Float trainingFraction) {
            this.trainingFraction = trainingFraction;
            this.__explicitlySet__.add("trainingFraction");
            return this;
        }

        public Builder windowSize(Integer windowSize) {
            this.windowSize = windowSize;
            this.__explicitlySet__.add("windowSize");
            return this;
        }

        public Builder dataAssetIds(List<String> dataAssetIds) {
            this.dataAssetIds = dataAssetIds;
            this.__explicitlySet__.add("dataAssetIds");
            return this;
        }

        public ModelTrainingDetails build() {
            ModelTrainingDetails model = new ModelTrainingDetails(this.algorithmHint, this.targetFap, this.trainingFraction, this.windowSize, this.dataAssetIds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModelTrainingDetails model) {
            if (model.wasPropertyExplicitlySet("algorithmHint")) {
                this.algorithmHint(model.getAlgorithmHint());
            }
            if (model.wasPropertyExplicitlySet("targetFap")) {
                this.targetFap(model.getTargetFap());
            }
            if (model.wasPropertyExplicitlySet("trainingFraction")) {
                this.trainingFraction(model.getTrainingFraction());
            }
            if (model.wasPropertyExplicitlySet("windowSize")) {
                this.windowSize(model.getWindowSize());
            }
            if (model.wasPropertyExplicitlySet("dataAssetIds")) {
                this.dataAssetIds(model.getDataAssetIds());
            }
            return this;
        }
    }
}

