/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAiPrivateEndpointRequest
extends BmcRequest<Void> {
    private String aiPrivateEndpointId;
    private String opcRequestId;

    public String getAiPrivateEndpointId() {
        return this.aiPrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().aiPrivateEndpointId(this.aiPrivateEndpointId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",aiPrivateEndpointId=").append(String.valueOf(this.aiPrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAiPrivateEndpointRequest)) {
            return false;
        }
        GetAiPrivateEndpointRequest other = (GetAiPrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.aiPrivateEndpointId, other.aiPrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.aiPrivateEndpointId == null ? 43 : this.aiPrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAiPrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String aiPrivateEndpointId = null;
        private String opcRequestId = null;

        public Builder aiPrivateEndpointId(String aiPrivateEndpointId) {
            this.aiPrivateEndpointId = aiPrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAiPrivateEndpointRequest o) {
            this.aiPrivateEndpointId(o.getAiPrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAiPrivateEndpointRequest build() {
            GetAiPrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAiPrivateEndpointRequest buildWithoutInvocationCallback() {
            GetAiPrivateEndpointRequest request = new GetAiPrivateEndpointRequest();
            request.aiPrivateEndpointId = this.aiPrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

