/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDataAssetRequest
extends BmcRequest<Void> {
    private String dataAssetId;
    private String opcRequestId;

    public String getDataAssetId() {
        return this.dataAssetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dataAssetId(this.dataAssetId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataAssetId=").append(String.valueOf(this.dataAssetId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDataAssetRequest)) {
            return false;
        }
        GetDataAssetRequest other = (GetDataAssetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataAssetId, other.dataAssetId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataAssetId == null ? 43 : this.dataAssetId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataAssetRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataAssetId = null;
        private String opcRequestId = null;

        public Builder dataAssetId(String dataAssetId) {
            this.dataAssetId = dataAssetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataAssetRequest o) {
            this.dataAssetId(o.getDataAssetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataAssetRequest build() {
            GetDataAssetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDataAssetRequest buildWithoutInvocationCallback() {
            GetDataAssetRequest request = new GetDataAssetRequest();
            request.dataAssetId = this.dataAssetId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

