/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aianomalydetection.model.DataSourceDetails;
import com.oracle.bmc.aianomalydetection.model.InfluxDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="dataSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class DataSourceDetailsInflux
extends DataSourceDetails {
    @JsonProperty(value="versionSpecificDetails")
    private final InfluxDetails versionSpecificDetails;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="passwordSecretId")
    private final String passwordSecretId;
    @JsonProperty(value="measurementName")
    private final String measurementName;
    @JsonProperty(value="url")
    private final String url;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DataSourceDetailsInflux(InfluxDetails versionSpecificDetails, String userName, String passwordSecretId, String measurementName, String url) {
        this.versionSpecificDetails = versionSpecificDetails;
        this.userName = userName;
        this.passwordSecretId = passwordSecretId;
        this.measurementName = measurementName;
        this.url = url;
    }

    public InfluxDetails getVersionSpecificDetails() {
        return this.versionSpecificDetails;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPasswordSecretId() {
        return this.passwordSecretId;
    }

    public String getMeasurementName() {
        return this.measurementName;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DataSourceDetailsInflux(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", versionSpecificDetails=").append(String.valueOf((Object)this.versionSpecificDetails));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", passwordSecretId=").append(String.valueOf(this.passwordSecretId));
        sb.append(", measurementName=").append(String.valueOf(this.measurementName));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSourceDetailsInflux)) {
            return false;
        }
        DataSourceDetailsInflux other = (DataSourceDetailsInflux)((Object)o);
        return Objects.equals((Object)this.versionSpecificDetails, (Object)other.versionSpecificDetails) && Objects.equals(this.userName, other.userName) && Objects.equals(this.passwordSecretId, other.passwordSecretId) && Objects.equals(this.measurementName, other.measurementName) && Objects.equals(this.url, other.url) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.versionSpecificDetails == null ? 43 : this.versionSpecificDetails.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.passwordSecretId == null ? 43 : this.passwordSecretId.hashCode());
        result = result * 59 + (this.measurementName == null ? 43 : this.measurementName.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="versionSpecificDetails")
        private InfluxDetails versionSpecificDetails;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="passwordSecretId")
        private String passwordSecretId;
        @JsonProperty(value="measurementName")
        private String measurementName;
        @JsonProperty(value="url")
        private String url;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder versionSpecificDetails(InfluxDetails versionSpecificDetails) {
            this.versionSpecificDetails = versionSpecificDetails;
            this.__explicitlySet__.add("versionSpecificDetails");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder passwordSecretId(String passwordSecretId) {
            this.passwordSecretId = passwordSecretId;
            this.__explicitlySet__.add("passwordSecretId");
            return this;
        }

        public Builder measurementName(String measurementName) {
            this.measurementName = measurementName;
            this.__explicitlySet__.add("measurementName");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public DataSourceDetailsInflux build() {
            DataSourceDetailsInflux model = new DataSourceDetailsInflux(this.versionSpecificDetails, this.userName, this.passwordSecretId, this.measurementName, this.url);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DataSourceDetailsInflux model) {
            if (model.wasPropertyExplicitlySet("versionSpecificDetails")) {
                this.versionSpecificDetails(model.getVersionSpecificDetails());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("passwordSecretId")) {
                this.passwordSecretId(model.getPasswordSecretId());
            }
            if (model.wasPropertyExplicitlySet("measurementName")) {
                this.measurementName(model.getMeasurementName());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            return this;
        }
    }
}

