/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aianomalydetection.model.InputJobDetails;
import com.oracle.bmc.aianomalydetection.model.OutputJobDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DetectAnomalyJob
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="modelId")
    private final String modelId;
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="sensitivity")
    private final Float sensitivity;
    @JsonProperty(value="areAllEstimatesRequired")
    private final Boolean areAllEstimatesRequired;
    @JsonProperty(value="inputDetails")
    private final InputJobDetails inputDetails;
    @JsonProperty(value="outputDetails")
    private final OutputJobDetails outputDetails;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleStateDetails")
    private final String lifecycleStateDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Object> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "modelId", "projectId", "sensitivity", "areAllEstimatesRequired", "inputDetails", "outputDetails", "timeAccepted", "timeStarted", "timeFinished", "lifecycleState", "lifecycleStateDetails", "freeformTags", "definedTags", "systemTags"})
    public DetectAnomalyJob(String id, String compartmentId, String displayName, String description, String modelId, String projectId, Float sensitivity, Boolean areAllEstimatesRequired, InputJobDetails inputDetails, OutputJobDetails outputDetails, Date timeAccepted, Date timeStarted, Date timeFinished, LifecycleState lifecycleState, String lifecycleStateDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Object> systemTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.modelId = modelId;
        this.projectId = projectId;
        this.sensitivity = sensitivity;
        this.areAllEstimatesRequired = areAllEstimatesRequired;
        this.inputDetails = inputDetails;
        this.outputDetails = outputDetails;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
        this.lifecycleState = lifecycleState;
        this.lifecycleStateDetails = lifecycleStateDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Float getSensitivity() {
        return this.sensitivity;
    }

    public Boolean getAreAllEstimatesRequired() {
        return this.areAllEstimatesRequired;
    }

    public InputJobDetails getInputDetails() {
        return this.inputDetails;
    }

    public OutputJobDetails getOutputDetails() {
        return this.outputDetails;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleStateDetails() {
        return this.lifecycleStateDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Object> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DetectAnomalyJob(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", modelId=").append(String.valueOf(this.modelId));
        sb.append(", projectId=").append(String.valueOf(this.projectId));
        sb.append(", sensitivity=").append(String.valueOf(this.sensitivity));
        sb.append(", areAllEstimatesRequired=").append(String.valueOf(this.areAllEstimatesRequired));
        sb.append(", inputDetails=").append(String.valueOf((Object)this.inputDetails));
        sb.append(", outputDetails=").append(String.valueOf((Object)this.outputDetails));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleStateDetails=").append(String.valueOf(this.lifecycleStateDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DetectAnomalyJob)) {
            return false;
        }
        DetectAnomalyJob other = (DetectAnomalyJob)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.sensitivity, other.sensitivity) && Objects.equals(this.areAllEstimatesRequired, other.areAllEstimatesRequired) && Objects.equals((Object)this.inputDetails, (Object)other.inputDetails) && Objects.equals((Object)this.outputDetails, (Object)other.outputDetails) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleStateDetails, other.lifecycleStateDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.sensitivity == null ? 43 : this.sensitivity.hashCode());
        result = result * 59 + (this.areAllEstimatesRequired == null ? 43 : this.areAllEstimatesRequired.hashCode());
        result = result * 59 + (this.inputDetails == null ? 43 : this.inputDetails.hashCode());
        result = result * 59 + (this.outputDetails == null ? 43 : this.outputDetails.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleStateDetails == null ? 43 : this.lifecycleStateDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Succeeded("SUCCEEDED"),
        PartiallySucceeded("PARTIALLY_SUCCEEDED"),
        Failed("FAILED"),
        Accepted("ACCEPTED"),
        Canceled("CANCELED"),
        InProgress("IN_PROGRESS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="modelId")
        private String modelId;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="sensitivity")
        private Float sensitivity;
        @JsonProperty(value="areAllEstimatesRequired")
        private Boolean areAllEstimatesRequired;
        @JsonProperty(value="inputDetails")
        private InputJobDetails inputDetails;
        @JsonProperty(value="outputDetails")
        private OutputJobDetails outputDetails;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleStateDetails")
        private String lifecycleStateDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Object> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            this.__explicitlySet__.add("modelId");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder sensitivity(Float sensitivity) {
            this.sensitivity = sensitivity;
            this.__explicitlySet__.add("sensitivity");
            return this;
        }

        public Builder areAllEstimatesRequired(Boolean areAllEstimatesRequired) {
            this.areAllEstimatesRequired = areAllEstimatesRequired;
            this.__explicitlySet__.add("areAllEstimatesRequired");
            return this;
        }

        public Builder inputDetails(InputJobDetails inputDetails) {
            this.inputDetails = inputDetails;
            this.__explicitlySet__.add("inputDetails");
            return this;
        }

        public Builder outputDetails(OutputJobDetails outputDetails) {
            this.outputDetails = outputDetails;
            this.__explicitlySet__.add("outputDetails");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleStateDetails(String lifecycleStateDetails) {
            this.lifecycleStateDetails = lifecycleStateDetails;
            this.__explicitlySet__.add("lifecycleStateDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Object> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public DetectAnomalyJob build() {
            DetectAnomalyJob model = new DetectAnomalyJob(this.id, this.compartmentId, this.displayName, this.description, this.modelId, this.projectId, this.sensitivity, this.areAllEstimatesRequired, this.inputDetails, this.outputDetails, this.timeAccepted, this.timeStarted, this.timeFinished, this.lifecycleState, this.lifecycleStateDetails, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DetectAnomalyJob model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("modelId")) {
                this.modelId(model.getModelId());
            }
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("sensitivity")) {
                this.sensitivity(model.getSensitivity());
            }
            if (model.wasPropertyExplicitlySet("areAllEstimatesRequired")) {
                this.areAllEstimatesRequired(model.getAreAllEstimatesRequired());
            }
            if (model.wasPropertyExplicitlySet("inputDetails")) {
                this.inputDetails(model.getInputDetails());
            }
            if (model.wasPropertyExplicitlySet("outputDetails")) {
                this.outputDetails(model.getOutputDetails());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleStateDetails")) {
                this.lifecycleStateDetails(model.getLifecycleStateDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

