/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aianomalydetection.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aianomalydetection.model.DataItem;
import com.oracle.bmc.aianomalydetection.model.InputDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="inputType")
@JsonFilter(value="explicitlySetFilter")
public final class InlineInputDetails
extends InputDetails {
    @JsonProperty(value="signalNames")
    private final List<String> signalNames;
    @JsonProperty(value="data")
    private final List<DataItem> data;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public InlineInputDetails(List<String> signalNames, List<DataItem> data) {
        this.signalNames = signalNames;
        this.data = data;
    }

    public List<String> getSignalNames() {
        return this.signalNames;
    }

    public List<DataItem> getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InlineInputDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", signalNames=").append(String.valueOf(this.signalNames));
        sb.append(", data=").append(String.valueOf(this.data));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InlineInputDetails)) {
            return false;
        }
        InlineInputDetails other = (InlineInputDetails)((Object)o);
        return Objects.equals(this.signalNames, other.signalNames) && Objects.equals(this.data, other.data) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.signalNames == null ? 43 : this.signalNames.hashCode());
        result = result * 59 + (this.data == null ? 43 : this.data.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="signalNames")
        private List<String> signalNames;
        @JsonProperty(value="data")
        private List<DataItem> data;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder signalNames(List<String> signalNames) {
            this.signalNames = signalNames;
            this.__explicitlySet__.add("signalNames");
            return this;
        }

        public Builder data(List<DataItem> data) {
            this.data = data;
            this.__explicitlySet__.add("data");
            return this;
        }

        public InlineInputDetails build() {
            InlineInputDetails model = new InlineInputDetails(this.signalNames, this.data);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InlineInputDetails model) {
            if (model.wasPropertyExplicitlySet("signalNames")) {
                this.signalNames(model.getSignalNames());
            }
            if (model.wasPropertyExplicitlySet("data")) {
                this.data(model.getData());
            }
            return this;
        }
    }
}

