/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aidocument.AIServiceDocumentAsync;
import com.oracle.bmc.aidocument.model.ProcessorJob;
import com.oracle.bmc.aidocument.requests.CancelProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.CreateProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.GetProcessorJobRequest;
import com.oracle.bmc.aidocument.responses.CancelProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.CreateProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.GetProcessorJobResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceDocumentAsyncClient
extends BaseAsyncClient
implements AIServiceDocumentAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICEDOCUMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://document.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceDocumentAsyncClient.class);

    AIServiceDocumentAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelProcessorJobResponse> cancelProcessorJob(CancelProcessorJobRequest request, AsyncHandler<CancelProcessorJobRequest, CancelProcessorJobResponse> handler) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelProcessorJobResponse::builder).logger(LOG, "cancelProcessorJob").serviceDetails("AIServiceDocument", "CancelProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/CancelProcessorJob").method(Method.POST).requestBuilder(CancelProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelProcessorJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateProcessorJobResponse> createProcessorJob(CreateProcessorJobRequest request, AsyncHandler<CreateProcessorJobRequest, CreateProcessorJobResponse> handler) {
        Objects.requireNonNull(request.getCreateProcessorJobDetails(), "createProcessorJobDetails is required");
        return this.clientCall(request, CreateProcessorJobResponse::builder).logger(LOG, "createProcessorJob").serviceDetails("AIServiceDocument", "CreateProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/CreateProcessorJob").method(Method.POST).requestBuilder(CreateProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ProcessorJob.class, CreateProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("opc-request-id", CreateProcessorJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateProcessorJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetProcessorJobResponse> getProcessorJob(GetProcessorJobRequest request, AsyncHandler<GetProcessorJobRequest, GetProcessorJobResponse> handler) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProcessorJobResponse::builder).logger(LOG, "getProcessorJob").serviceDetails("AIServiceDocument", "GetProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/GetProcessorJob").method(Method.GET).requestBuilder(GetProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProcessorJob.class, GetProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("etag", GetProcessorJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProcessorJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceDocumentAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceDocumentAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceDocumentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AIServiceDocumentAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceDocumentAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

