/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aidocument.model.DocumentFeature;
import com.oracle.bmc.aidocument.model.DocumentType;
import com.oracle.bmc.aidocument.model.ProcessorConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="processorType")
@JsonFilter(value="explicitlySetFilter")
public final class GeneralProcessorConfig
extends ProcessorConfig {
    @JsonProperty(value="documentType")
    private final DocumentType documentType;
    @JsonProperty(value="features")
    private final List<DocumentFeature> features;
    @JsonProperty(value="isZipOutputEnabled")
    private final Boolean isZipOutputEnabled;
    @JsonProperty(value="language")
    private final String language;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public GeneralProcessorConfig(DocumentType documentType, List<DocumentFeature> features, Boolean isZipOutputEnabled, String language) {
        this.documentType = documentType;
        this.features = features;
        this.isZipOutputEnabled = isZipOutputEnabled;
        this.language = language;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public List<DocumentFeature> getFeatures() {
        return this.features;
    }

    public Boolean getIsZipOutputEnabled() {
        return this.isZipOutputEnabled;
    }

    public String getLanguage() {
        return this.language;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GeneralProcessorConfig(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", documentType=").append(String.valueOf((Object)this.documentType));
        sb.append(", features=").append(String.valueOf(this.features));
        sb.append(", isZipOutputEnabled=").append(String.valueOf(this.isZipOutputEnabled));
        sb.append(", language=").append(String.valueOf(this.language));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeneralProcessorConfig)) {
            return false;
        }
        GeneralProcessorConfig other = (GeneralProcessorConfig)((Object)o);
        return Objects.equals((Object)this.documentType, (Object)other.documentType) && Objects.equals(this.features, other.features) && Objects.equals(this.isZipOutputEnabled, other.isZipOutputEnabled) && Objects.equals(this.language, other.language) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.documentType == null ? 43 : this.documentType.hashCode());
        result = result * 59 + (this.features == null ? 43 : this.features.hashCode());
        result = result * 59 + (this.isZipOutputEnabled == null ? 43 : this.isZipOutputEnabled.hashCode());
        result = result * 59 + (this.language == null ? 43 : this.language.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="documentType")
        private DocumentType documentType;
        @JsonProperty(value="features")
        private List<DocumentFeature> features;
        @JsonProperty(value="isZipOutputEnabled")
        private Boolean isZipOutputEnabled;
        @JsonProperty(value="language")
        private String language;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder documentType(DocumentType documentType) {
            this.documentType = documentType;
            this.__explicitlySet__.add("documentType");
            return this;
        }

        public Builder features(List<DocumentFeature> features) {
            this.features = features;
            this.__explicitlySet__.add("features");
            return this;
        }

        public Builder isZipOutputEnabled(Boolean isZipOutputEnabled) {
            this.isZipOutputEnabled = isZipOutputEnabled;
            this.__explicitlySet__.add("isZipOutputEnabled");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.__explicitlySet__.add("language");
            return this;
        }

        public GeneralProcessorConfig build() {
            GeneralProcessorConfig model = new GeneralProcessorConfig(this.documentType, this.features, this.isZipOutputEnabled, this.language);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GeneralProcessorConfig model) {
            if (model.wasPropertyExplicitlySet("documentType")) {
                this.documentType(model.getDocumentType());
            }
            if (model.wasPropertyExplicitlySet("features")) {
                this.features(model.getFeatures());
            }
            if (model.wasPropertyExplicitlySet("isZipOutputEnabled")) {
                this.isZipOutputEnabled(model.getIsZipOutputEnabled());
            }
            if (model.wasPropertyExplicitlySet("language")) {
                this.language(model.getLanguage());
            }
            return this;
        }
    }
}

