/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aidocument.AIServiceDocument;
import com.oracle.bmc.aidocument.AIServiceDocumentPaginators;
import com.oracle.bmc.aidocument.AIServiceDocumentWaiters;
import com.oracle.bmc.aidocument.model.AnalyzeDocumentResult;
import com.oracle.bmc.aidocument.model.Model;
import com.oracle.bmc.aidocument.model.ModelCollection;
import com.oracle.bmc.aidocument.model.PatchResponseMessage;
import com.oracle.bmc.aidocument.model.ProcessorJob;
import com.oracle.bmc.aidocument.model.Project;
import com.oracle.bmc.aidocument.model.ProjectCollection;
import com.oracle.bmc.aidocument.model.WorkRequest;
import com.oracle.bmc.aidocument.model.WorkRequestErrorCollection;
import com.oracle.bmc.aidocument.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.aidocument.model.WorkRequestSummaryCollection;
import com.oracle.bmc.aidocument.requests.AnalyzeDocumentRequest;
import com.oracle.bmc.aidocument.requests.CancelProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.CancelWorkRequestRequest;
import com.oracle.bmc.aidocument.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.aidocument.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.aidocument.requests.CreateModelRequest;
import com.oracle.bmc.aidocument.requests.CreateProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.CreateProjectRequest;
import com.oracle.bmc.aidocument.requests.DeleteModelRequest;
import com.oracle.bmc.aidocument.requests.DeleteProjectRequest;
import com.oracle.bmc.aidocument.requests.GetModelRequest;
import com.oracle.bmc.aidocument.requests.GetProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.GetProjectRequest;
import com.oracle.bmc.aidocument.requests.GetWorkRequestRequest;
import com.oracle.bmc.aidocument.requests.ListModelsRequest;
import com.oracle.bmc.aidocument.requests.ListProjectsRequest;
import com.oracle.bmc.aidocument.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aidocument.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aidocument.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aidocument.requests.PatchModelRequest;
import com.oracle.bmc.aidocument.requests.UpdateModelRequest;
import com.oracle.bmc.aidocument.requests.UpdateProjectRequest;
import com.oracle.bmc.aidocument.responses.AnalyzeDocumentResponse;
import com.oracle.bmc.aidocument.responses.CancelProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.CancelWorkRequestResponse;
import com.oracle.bmc.aidocument.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.aidocument.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.aidocument.responses.CreateModelResponse;
import com.oracle.bmc.aidocument.responses.CreateProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.CreateProjectResponse;
import com.oracle.bmc.aidocument.responses.DeleteModelResponse;
import com.oracle.bmc.aidocument.responses.DeleteProjectResponse;
import com.oracle.bmc.aidocument.responses.GetModelResponse;
import com.oracle.bmc.aidocument.responses.GetProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.GetProjectResponse;
import com.oracle.bmc.aidocument.responses.GetWorkRequestResponse;
import com.oracle.bmc.aidocument.responses.ListModelsResponse;
import com.oracle.bmc.aidocument.responses.ListProjectsResponse;
import com.oracle.bmc.aidocument.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aidocument.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aidocument.responses.ListWorkRequestsResponse;
import com.oracle.bmc.aidocument.responses.PatchModelResponse;
import com.oracle.bmc.aidocument.responses.UpdateModelResponse;
import com.oracle.bmc.aidocument.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceDocumentClient
extends BaseSyncClient
implements AIServiceDocument {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICEDOCUMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://document.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceDocumentClient.class);
    private final AIServiceDocumentWaiters waiters;
    private final AIServiceDocumentPaginators paginators;

    AIServiceDocumentClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("AIServiceDocument-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AIServiceDocumentWaiters(executorService, this);
        this.paginators = new AIServiceDocumentPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AnalyzeDocumentResponse analyzeDocument(AnalyzeDocumentRequest request) {
        Objects.requireNonNull(request.getAnalyzeDocumentDetails(), "analyzeDocumentDetails is required");
        return (AnalyzeDocumentResponse)this.clientCall(request, AnalyzeDocumentResponse::builder).logger(LOG, "analyzeDocument").serviceDetails("AIServiceDocument", "AnalyzeDocument", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/AnalyzeDocumentResult/AnalyzeDocument").method(Method.POST).requestBuilder(AnalyzeDocumentRequest::builder).basePath("/20221109").appendPathParam("actions").appendPathParam("analyzeDocument").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyzeDocumentResult.class, AnalyzeDocumentResponse.Builder::analyzeDocumentResult).handleResponseHeaderString("Content-Location", AnalyzeDocumentResponse.Builder::contentLocation).handleResponseHeaderString("location", AnalyzeDocumentResponse.Builder::location).handleResponseHeaderString("etag", AnalyzeDocumentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AnalyzeDocumentResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CancelProcessorJobResponse cancelProcessorJob(CancelProcessorJobRequest request) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return (CancelProcessorJobResponse)this.clientCall(request, CancelProcessorJobResponse::builder).logger(LOG, "cancelProcessorJob").serviceDetails("AIServiceDocument", "CancelProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/CancelProcessorJob").method(Method.POST).requestBuilder(CancelProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelProcessorJobResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("AIServiceDocument", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeModelCompartmentResponse changeModelCompartment(ChangeModelCompartmentRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return (ChangeModelCompartmentResponse)this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("AIServiceDocument", "ChangeModelCompartment", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/ChangeModelCompartment").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return (ChangeProjectCompartmentResponse)this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("AIServiceDocument", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return (CreateModelResponse)this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("AIServiceDocument", "CreateModel", "").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20221109").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("Content-Location", CreateModelResponse.Builder::contentLocation).handleResponseHeaderString("location", CreateModelResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateProcessorJobResponse createProcessorJob(CreateProcessorJobRequest request) {
        Objects.requireNonNull(request.getCreateProcessorJobDetails(), "createProcessorJobDetails is required");
        return (CreateProcessorJobResponse)this.clientCall(request, CreateProcessorJobResponse::builder).logger(LOG, "createProcessorJob").serviceDetails("AIServiceDocument", "CreateProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/CreateProcessorJob").method(Method.POST).requestBuilder(CreateProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ProcessorJob.class, CreateProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("opc-request-id", CreateProcessorJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateProcessorJobResponse.Builder::etag).operationUsesDefaultRetries().callSync();
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return (CreateProjectResponse)this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("AIServiceDocument", "CreateProject", "").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20221109").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("Content-Location", CreateProjectResponse.Builder::contentLocation).handleResponseHeaderString("location", CreateProjectResponse.Builder::location).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (DeleteModelResponse)this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("AIServiceDocument", "DeleteModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/DeleteModel").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (DeleteProjectResponse)this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("AIServiceDocument", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return (GetModelResponse)this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("AIServiceDocument", "GetModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/GetModel").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetProcessorJobResponse getProcessorJob(GetProcessorJobRequest request) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return (GetProcessorJobResponse)this.clientCall(request, GetProcessorJobResponse::builder).logger(LOG, "getProcessorJob").serviceDetails("AIServiceDocument", "GetProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/GetProcessorJob").method(Method.GET).requestBuilder(GetProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProcessorJob.class, GetProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("etag", GetProcessorJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProcessorJobResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (GetProjectResponse)this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("AIServiceDocument", "GetProject", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("AIServiceDocument", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        return (ListModelsResponse)this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("AIServiceDocument", "ListModels", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/ListModels").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20221109").appendPathParam("models").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelCollection.class, ListModelsResponse.Builder::modelCollection).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        return (ListProjectsResponse)this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("AIServiceDocument", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20221109").appendPathParam("projects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("AIServiceDocument", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("AIServiceDocument", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).operationUsesDefaultRetries().callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("AIServiceDocument", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).operationUsesDefaultRetries().callSync();
    }

    @Override
    public PatchModelResponse patchModel(PatchModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchModelDetails(), "patchModelDetails is required");
        return (PatchModelResponse)this.clientCall(request, PatchModelResponse::builder).logger(LOG, "patchModel").serviceDetails("AIServiceDocument", "PatchModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/PatchModel").method(Method.PATCH).requestBuilder(PatchModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PatchResponseMessage.class, PatchModelResponse.Builder::patchResponseMessage).handleResponseHeaderString("opc-work-request-id", PatchModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PatchModelResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PatchModelResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return (UpdateModelResponse)this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("AIServiceDocument", "UpdateModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/UpdateModel").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return (UpdateProjectResponse)this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("AIServiceDocument", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public AIServiceDocumentWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AIServiceDocumentPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public AIServiceDocumentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceDocumentClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceDocumentClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public AIServiceDocumentClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceDocumentClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceDocumentClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "aidocument";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"aidocument");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AIServiceDocumentClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceDocumentClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

