/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DatasetSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="trainingSampleCount")
    private final Integer trainingSampleCount;
    @JsonProperty(value="validationSampleCount")
    private final Integer validationSampleCount;
    @JsonProperty(value="testSampleCount")
    private final Integer testSampleCount;

    @Deprecated
    @ConstructorProperties(value={"trainingSampleCount", "validationSampleCount", "testSampleCount"})
    public DatasetSummary(Integer trainingSampleCount, Integer validationSampleCount, Integer testSampleCount) {
        this.trainingSampleCount = trainingSampleCount;
        this.validationSampleCount = validationSampleCount;
        this.testSampleCount = testSampleCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTrainingSampleCount() {
        return this.trainingSampleCount;
    }

    public Integer getValidationSampleCount() {
        return this.validationSampleCount;
    }

    public Integer getTestSampleCount() {
        return this.testSampleCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DatasetSummary(");
        sb.append("super=").append(super.toString());
        sb.append("trainingSampleCount=").append(String.valueOf(this.trainingSampleCount));
        sb.append(", validationSampleCount=").append(String.valueOf(this.validationSampleCount));
        sb.append(", testSampleCount=").append(String.valueOf(this.testSampleCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatasetSummary)) {
            return false;
        }
        DatasetSummary other = (DatasetSummary)((Object)o);
        return Objects.equals(this.trainingSampleCount, other.trainingSampleCount) && Objects.equals(this.validationSampleCount, other.validationSampleCount) && Objects.equals(this.testSampleCount, other.testSampleCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.trainingSampleCount == null ? 43 : this.trainingSampleCount.hashCode());
        result = result * 59 + (this.validationSampleCount == null ? 43 : this.validationSampleCount.hashCode());
        result = result * 59 + (this.testSampleCount == null ? 43 : this.testSampleCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="trainingSampleCount")
        private Integer trainingSampleCount;
        @JsonProperty(value="validationSampleCount")
        private Integer validationSampleCount;
        @JsonProperty(value="testSampleCount")
        private Integer testSampleCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder trainingSampleCount(Integer trainingSampleCount) {
            this.trainingSampleCount = trainingSampleCount;
            this.__explicitlySet__.add("trainingSampleCount");
            return this;
        }

        public Builder validationSampleCount(Integer validationSampleCount) {
            this.validationSampleCount = validationSampleCount;
            this.__explicitlySet__.add("validationSampleCount");
            return this;
        }

        public Builder testSampleCount(Integer testSampleCount) {
            this.testSampleCount = testSampleCount;
            this.__explicitlySet__.add("testSampleCount");
            return this;
        }

        public DatasetSummary build() {
            DatasetSummary model = new DatasetSummary(this.trainingSampleCount, this.validationSampleCount, this.testSampleCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DatasetSummary model) {
            if (model.wasPropertyExplicitlySet("trainingSampleCount")) {
                this.trainingSampleCount(model.getTrainingSampleCount());
            }
            if (model.wasPropertyExplicitlySet("validationSampleCount")) {
                this.validationSampleCount(model.getValidationSampleCount());
            }
            if (model.wasPropertyExplicitlySet("testSampleCount")) {
                this.testSampleCount(model.getTestSampleCount());
            }
            return this;
        }
    }
}

