/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.aidocument.model.PatchModelDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class PatchModelRequest
extends BmcRequest<PatchModelDetails> {
    private String modelId;
    private PatchModelDetails patchModelDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getModelId() {
        return this.modelId;
    }

    public PatchModelDetails getPatchModelDetails() {
        return this.patchModelDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public PatchModelDetails getBody$() {
        return this.patchModelDetails;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).patchModelDetails(this.patchModelDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",patchModelDetails=").append(String.valueOf((Object)this.patchModelDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchModelRequest)) {
            return false;
        }
        PatchModelRequest other = (PatchModelRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals((Object)this.patchModelDetails, (Object)other.patchModelDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.patchModelDetails == null ? 43 : this.patchModelDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<PatchModelRequest, PatchModelDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private PatchModelDetails patchModelDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder patchModelDetails(PatchModelDetails patchModelDetails) {
            this.patchModelDetails = patchModelDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(PatchModelRequest o) {
            this.modelId(o.getModelId());
            this.patchModelDetails(o.getPatchModelDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public PatchModelRequest build() {
            PatchModelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(PatchModelDetails body) {
            this.patchModelDetails(body);
            return this;
        }

        public PatchModelRequest buildWithoutInvocationCallback() {
            PatchModelRequest request = new PatchModelRequest();
            request.modelId = this.modelId;
            request.patchModelDetails = this.patchModelDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

