/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aidocument.model.AnalyzeDocumentResult;
import com.oracle.bmc.aidocument.model.DocumentDetails;
import com.oracle.bmc.aidocument.model.DocumentFeature;
import com.oracle.bmc.aidocument.model.DocumentType;
import com.oracle.bmc.aidocument.model.OutputLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AnalyzeDocumentDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="features")
    private final List<DocumentFeature> features;
    @JsonProperty(value="document")
    private final DocumentDetails document;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="outputLocation")
    private final OutputLocation outputLocation;
    @JsonProperty(value="language")
    private final String language;
    @JsonProperty(value="documentType")
    private final DocumentType documentType;
    @JsonProperty(value="ocrData")
    private final AnalyzeDocumentResult ocrData;

    @Deprecated
    @ConstructorProperties(value={"features", "document", "compartmentId", "outputLocation", "language", "documentType", "ocrData"})
    public AnalyzeDocumentDetails(List<DocumentFeature> features, DocumentDetails document, String compartmentId, OutputLocation outputLocation, String language, DocumentType documentType, AnalyzeDocumentResult ocrData) {
        this.features = features;
        this.document = document;
        this.compartmentId = compartmentId;
        this.outputLocation = outputLocation;
        this.language = language;
        this.documentType = documentType;
        this.ocrData = ocrData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<DocumentFeature> getFeatures() {
        return this.features;
    }

    public DocumentDetails getDocument() {
        return this.document;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public String getLanguage() {
        return this.language;
    }

    public DocumentType getDocumentType() {
        return this.documentType;
    }

    public AnalyzeDocumentResult getOcrData() {
        return this.ocrData;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AnalyzeDocumentDetails(");
        sb.append("super=").append(super.toString());
        sb.append("features=").append(String.valueOf(this.features));
        sb.append(", document=").append(String.valueOf((Object)this.document));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", language=").append(String.valueOf(this.language));
        sb.append(", documentType=").append(String.valueOf((Object)this.documentType));
        sb.append(", ocrData=").append(String.valueOf((Object)this.ocrData));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzeDocumentDetails)) {
            return false;
        }
        AnalyzeDocumentDetails other = (AnalyzeDocumentDetails)((Object)o);
        return Objects.equals(this.features, other.features) && Objects.equals((Object)this.document, (Object)other.document) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals(this.language, other.language) && Objects.equals((Object)this.documentType, (Object)other.documentType) && Objects.equals((Object)this.ocrData, (Object)other.ocrData) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.features == null ? 43 : this.features.hashCode());
        result = result * 59 + (this.document == null ? 43 : this.document.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.language == null ? 43 : this.language.hashCode());
        result = result * 59 + (this.documentType == null ? 43 : this.documentType.hashCode());
        result = result * 59 + (this.ocrData == null ? 43 : this.ocrData.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="features")
        private List<DocumentFeature> features;
        @JsonProperty(value="document")
        private DocumentDetails document;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="outputLocation")
        private OutputLocation outputLocation;
        @JsonProperty(value="language")
        private String language;
        @JsonProperty(value="documentType")
        private DocumentType documentType;
        @JsonProperty(value="ocrData")
        private AnalyzeDocumentResult ocrData;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder features(List<DocumentFeature> features) {
            this.features = features;
            this.__explicitlySet__.add("features");
            return this;
        }

        public Builder document(DocumentDetails document) {
            this.document = document;
            this.__explicitlySet__.add("document");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.__explicitlySet__.add("language");
            return this;
        }

        public Builder documentType(DocumentType documentType) {
            this.documentType = documentType;
            this.__explicitlySet__.add("documentType");
            return this;
        }

        public Builder ocrData(AnalyzeDocumentResult ocrData) {
            this.ocrData = ocrData;
            this.__explicitlySet__.add("ocrData");
            return this;
        }

        public AnalyzeDocumentDetails build() {
            AnalyzeDocumentDetails model = new AnalyzeDocumentDetails(this.features, this.document, this.compartmentId, this.outputLocation, this.language, this.documentType, this.ocrData);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AnalyzeDocumentDetails model) {
            if (model.wasPropertyExplicitlySet("features")) {
                this.features(model.getFeatures());
            }
            if (model.wasPropertyExplicitlySet("document")) {
                this.document(model.getDocument());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("language")) {
                this.language(model.getLanguage());
            }
            if (model.wasPropertyExplicitlySet("documentType")) {
                this.documentType(model.getDocumentType());
            }
            if (model.wasPropertyExplicitlySet("ocrData")) {
                this.ocrData(model.getOcrData());
            }
            return this;
        }
    }
}

