/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KeyValueDetectionConfidenceEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="threshold")
    private final Float threshold;
    @JsonProperty(value="precision")
    private final Float precision;
    @JsonProperty(value="recall")
    private final Float recall;
    @JsonProperty(value="f1Score")
    private final Float f1Score;
    @JsonProperty(value="accuracy")
    private final Float accuracy;

    @Deprecated
    @ConstructorProperties(value={"threshold", "precision", "recall", "f1Score", "accuracy"})
    public KeyValueDetectionConfidenceEntry(Float threshold, Float precision, Float recall, Float f1Score, Float accuracy) {
        this.threshold = threshold;
        this.precision = precision;
        this.recall = recall;
        this.f1Score = f1Score;
        this.accuracy = accuracy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getThreshold() {
        return this.threshold;
    }

    public Float getPrecision() {
        return this.precision;
    }

    public Float getRecall() {
        return this.recall;
    }

    public Float getF1Score() {
        return this.f1Score;
    }

    public Float getAccuracy() {
        return this.accuracy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyValueDetectionConfidenceEntry(");
        sb.append("super=").append(super.toString());
        sb.append("threshold=").append(String.valueOf(this.threshold));
        sb.append(", precision=").append(String.valueOf(this.precision));
        sb.append(", recall=").append(String.valueOf(this.recall));
        sb.append(", f1Score=").append(String.valueOf(this.f1Score));
        sb.append(", accuracy=").append(String.valueOf(this.accuracy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyValueDetectionConfidenceEntry)) {
            return false;
        }
        KeyValueDetectionConfidenceEntry other = (KeyValueDetectionConfidenceEntry)((Object)o);
        return Objects.equals(this.threshold, other.threshold) && Objects.equals(this.precision, other.precision) && Objects.equals(this.recall, other.recall) && Objects.equals(this.f1Score, other.f1Score) && Objects.equals(this.accuracy, other.accuracy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.threshold == null ? 43 : this.threshold.hashCode());
        result = result * 59 + (this.precision == null ? 43 : this.precision.hashCode());
        result = result * 59 + (this.recall == null ? 43 : this.recall.hashCode());
        result = result * 59 + (this.f1Score == null ? 43 : this.f1Score.hashCode());
        result = result * 59 + (this.accuracy == null ? 43 : this.accuracy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="threshold")
        private Float threshold;
        @JsonProperty(value="precision")
        private Float precision;
        @JsonProperty(value="recall")
        private Float recall;
        @JsonProperty(value="f1Score")
        private Float f1Score;
        @JsonProperty(value="accuracy")
        private Float accuracy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder threshold(Float threshold) {
            this.threshold = threshold;
            this.__explicitlySet__.add("threshold");
            return this;
        }

        public Builder precision(Float precision) {
            this.precision = precision;
            this.__explicitlySet__.add("precision");
            return this;
        }

        public Builder recall(Float recall) {
            this.recall = recall;
            this.__explicitlySet__.add("recall");
            return this;
        }

        public Builder f1Score(Float f1Score) {
            this.f1Score = f1Score;
            this.__explicitlySet__.add("f1Score");
            return this;
        }

        public Builder accuracy(Float accuracy) {
            this.accuracy = accuracy;
            this.__explicitlySet__.add("accuracy");
            return this;
        }

        public KeyValueDetectionConfidenceEntry build() {
            KeyValueDetectionConfidenceEntry model = new KeyValueDetectionConfidenceEntry(this.threshold, this.precision, this.recall, this.f1Score, this.accuracy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KeyValueDetectionConfidenceEntry model) {
            if (model.wasPropertyExplicitlySet("threshold")) {
                this.threshold(model.getThreshold());
            }
            if (model.wasPropertyExplicitlySet("precision")) {
                this.precision(model.getPrecision());
            }
            if (model.wasPropertyExplicitlySet("recall")) {
                this.recall(model.getRecall());
            }
            if (model.wasPropertyExplicitlySet("f1Score")) {
                this.f1Score(model.getF1Score());
            }
            if (model.wasPropertyExplicitlySet("accuracy")) {
                this.accuracy(model.getAccuracy());
            }
            return this;
        }
    }
}

