/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.responses;

import com.oracle.bmc.aidocument.model.AnalyzeDocumentResult;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AnalyzeDocumentResponse
extends BmcResponse {
    private String contentLocation;
    private String location;
    private String etag;
    private String opcRequestId;
    private AnalyzeDocumentResult analyzeDocumentResult;

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getLocation() {
        return this.location;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public AnalyzeDocumentResult getAnalyzeDocumentResult() {
        return this.analyzeDocumentResult;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "contentLocation", "location", "etag", "opcRequestId", "analyzeDocumentResult"})
    private AnalyzeDocumentResponse(int __httpStatusCode__, Map<String, List<String>> headers, String contentLocation, String location, String etag, String opcRequestId, AnalyzeDocumentResult analyzeDocumentResult) {
        super(__httpStatusCode__, headers);
        this.contentLocation = contentLocation;
        this.location = location;
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.analyzeDocumentResult = analyzeDocumentResult;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",contentLocation=").append(String.valueOf(this.contentLocation));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",analyzeDocumentResult=").append(String.valueOf((Object)this.analyzeDocumentResult));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzeDocumentResponse)) {
            return false;
        }
        AnalyzeDocumentResponse other = (AnalyzeDocumentResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.contentLocation, other.contentLocation) && Objects.equals(this.location, other.location) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.analyzeDocumentResult, (Object)other.analyzeDocumentResult);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.contentLocation == null ? 43 : this.contentLocation.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.analyzeDocumentResult == null ? 43 : this.analyzeDocumentResult.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<AnalyzeDocumentResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String contentLocation;
        private String location;
        private String etag;
        private String opcRequestId;
        private AnalyzeDocumentResult analyzeDocumentResult;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder analyzeDocumentResult(AnalyzeDocumentResult analyzeDocumentResult) {
            this.analyzeDocumentResult = analyzeDocumentResult;
            return this;
        }

        public Builder copy(AnalyzeDocumentResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.contentLocation(o.getContentLocation());
            this.location(o.getLocation());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.analyzeDocumentResult(o.getAnalyzeDocumentResult());
            return this;
        }

        public AnalyzeDocumentResponse build() {
            return new AnalyzeDocumentResponse(this.__httpStatusCode__, this.headers, this.contentLocation, this.location, this.etag, this.opcRequestId, this.analyzeDocumentResult);
        }
    }
}

