/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aidocument.model.InputLocation;
import com.oracle.bmc.aidocument.model.OutputLocation;
import com.oracle.bmc.aidocument.model.ProcessorConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateProcessorJobDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="inputLocation")
    private final InputLocation inputLocation;
    @JsonProperty(value="outputLocation")
    private final OutputLocation outputLocation;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="processorConfig")
    private final ProcessorConfig processorConfig;

    @Deprecated
    @ConstructorProperties(value={"inputLocation", "outputLocation", "compartmentId", "displayName", "processorConfig"})
    public CreateProcessorJobDetails(InputLocation inputLocation, OutputLocation outputLocation, String compartmentId, String displayName, ProcessorConfig processorConfig) {
        this.inputLocation = inputLocation;
        this.outputLocation = outputLocation;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.processorConfig = processorConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public InputLocation getInputLocation() {
        return this.inputLocation;
    }

    public OutputLocation getOutputLocation() {
        return this.outputLocation;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ProcessorConfig getProcessorConfig() {
        return this.processorConfig;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateProcessorJobDetails(");
        sb.append("super=").append(super.toString());
        sb.append("inputLocation=").append(String.valueOf((Object)this.inputLocation));
        sb.append(", outputLocation=").append(String.valueOf((Object)this.outputLocation));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", processorConfig=").append(String.valueOf((Object)this.processorConfig));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateProcessorJobDetails)) {
            return false;
        }
        CreateProcessorJobDetails other = (CreateProcessorJobDetails)((Object)o);
        return Objects.equals((Object)this.inputLocation, (Object)other.inputLocation) && Objects.equals((Object)this.outputLocation, (Object)other.outputLocation) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.processorConfig, (Object)other.processorConfig) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.inputLocation == null ? 43 : this.inputLocation.hashCode());
        result = result * 59 + (this.outputLocation == null ? 43 : this.outputLocation.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.processorConfig == null ? 43 : this.processorConfig.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="inputLocation")
        private InputLocation inputLocation;
        @JsonProperty(value="outputLocation")
        private OutputLocation outputLocation;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="processorConfig")
        private ProcessorConfig processorConfig;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder inputLocation(InputLocation inputLocation) {
            this.inputLocation = inputLocation;
            this.__explicitlySet__.add("inputLocation");
            return this;
        }

        public Builder outputLocation(OutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            this.__explicitlySet__.add("outputLocation");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder processorConfig(ProcessorConfig processorConfig) {
            this.processorConfig = processorConfig;
            this.__explicitlySet__.add("processorConfig");
            return this;
        }

        public CreateProcessorJobDetails build() {
            CreateProcessorJobDetails model = new CreateProcessorJobDetails(this.inputLocation, this.outputLocation, this.compartmentId, this.displayName, this.processorConfig);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateProcessorJobDetails model) {
            if (model.wasPropertyExplicitlySet("inputLocation")) {
                this.inputLocation(model.getInputLocation());
            }
            if (model.wasPropertyExplicitlySet("outputLocation")) {
                this.outputLocation(model.getOutputLocation());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("processorConfig")) {
                this.processorConfig(model.getProcessorConfig());
            }
            return this;
        }
    }
}

