/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.aidocument.model.DatasetSummary;
import com.oracle.bmc.aidocument.model.DocumentClassificationModelMetrics;
import com.oracle.bmc.aidocument.model.KeyValueDetectionModelMetrics;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType", defaultImpl=ModelMetrics.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DocumentClassificationModelMetrics.class, name="DOCUMENT_CLASSIFICATION"), @JsonSubTypes.Type(value=KeyValueDetectionModelMetrics.class, name="KEY_VALUE_EXTRACTION")})
@JsonFilter(value="explicitlySetFilter")
public class ModelMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="datasetSummary")
    private final DatasetSummary datasetSummary;

    @Deprecated
    @ConstructorProperties(value={"datasetSummary"})
    protected ModelMetrics(DatasetSummary datasetSummary) {
        this.datasetSummary = datasetSummary;
    }

    public DatasetSummary getDatasetSummary() {
        return this.datasetSummary;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("datasetSummary=").append(String.valueOf((Object)this.datasetSummary));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelMetrics)) {
            return false;
        }
        ModelMetrics other = (ModelMetrics)((Object)o);
        return Objects.equals((Object)this.datasetSummary, (Object)other.datasetSummary) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.datasetSummary == null ? 43 : this.datasetSummary.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ModelType implements BmcEnum
    {
        KeyValueExtraction("KEY_VALUE_EXTRACTION"),
        DocumentClassification("DOCUMENT_CLASSIFICATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ModelType> map;

        private ModelType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ModelType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ModelType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ModelType.class);
            map = new HashMap<String, ModelType>();
            for (ModelType v : ModelType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

