/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PatchModelOperation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="operation")
    private final Operation operation;

    @Deprecated
    @ConstructorProperties(value={"path", "value", "operation"})
    public PatchModelOperation(String path, String value, Operation operation) {
        this.path = path;
        this.value = value;
        this.operation = operation;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPath() {
        return this.path;
    }

    public String getValue() {
        return this.value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PatchModelOperation(");
        sb.append("super=").append(super.toString());
        sb.append("path=").append(String.valueOf(this.path));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", operation=").append(String.valueOf((Object)this.operation));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchModelOperation)) {
            return false;
        }
        PatchModelOperation other = (PatchModelOperation)((Object)o);
        return Objects.equals(this.path, other.path) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.operation, (Object)other.operation) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Operation implements BmcEnum
    {
        Delete("DELETE"),
        Add("ADD"),
        Replace("REPLACE");

        private final String value;
        private static Map<String, Operation> map;

        private Operation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Operation: " + key);
        }

        static {
            map = new HashMap<String, Operation>();
            for (Operation v : Operation.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="operation")
        private Operation operation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder operation(Operation operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public PatchModelOperation build() {
            PatchModelOperation model = new PatchModelOperation(this.path, this.value, this.operation);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PatchModelOperation model) {
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            return this;
        }
    }
}

