/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteModelRequest
extends BmcRequest<Void> {
    private String modelId;
    private String ifMatch;
    private String opcRequestId;
    private Boolean isLockOverride;

    public String getModelId() {
        return this.modelId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    public Builder toBuilder() {
        return new Builder().modelId(this.modelId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelId=").append(String.valueOf(this.modelId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteModelRequest)) {
            return false;
        }
        DeleteModelRequest other = (DeleteModelRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelId, other.modelId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelId == null ? 43 : this.modelId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteModelRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean isLockOverride = null;

        public Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteModelRequest o) {
            this.modelId(o.getModelId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteModelRequest build() {
            DeleteModelRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteModelRequest buildWithoutInvocationCallback() {
            DeleteModelRequest request = new DeleteModelRequest();
            request.modelId = this.modelId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

