/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteProjectRequest
extends BmcRequest<Void> {
    private String projectId;
    private String ifMatch;
    private String opcRequestId;
    private Boolean isLockOverride;

    public String getProjectId() {
        return this.projectId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    public Builder toBuilder() {
        return new Builder().projectId(this.projectId).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",projectId=").append(String.valueOf(this.projectId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteProjectRequest)) {
            return false;
        }
        DeleteProjectRequest other = (DeleteProjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteProjectRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String projectId = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean isLockOverride = null;

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteProjectRequest o) {
            this.projectId(o.getProjectId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteProjectRequest build() {
            DeleteProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteProjectRequest buildWithoutInvocationCallback() {
            DeleteProjectRequest request = new DeleteProjectRequest();
            request.projectId = this.projectId;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

