/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.aidocument.AIServiceDocumentAsync;
import com.oracle.bmc.aidocument.model.AnalyzeDocumentResult;
import com.oracle.bmc.aidocument.model.Model;
import com.oracle.bmc.aidocument.model.ModelCollection;
import com.oracle.bmc.aidocument.model.PatchResponseMessage;
import com.oracle.bmc.aidocument.model.ProcessorJob;
import com.oracle.bmc.aidocument.model.Project;
import com.oracle.bmc.aidocument.model.ProjectCollection;
import com.oracle.bmc.aidocument.model.WorkRequest;
import com.oracle.bmc.aidocument.model.WorkRequestErrorCollection;
import com.oracle.bmc.aidocument.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.aidocument.model.WorkRequestSummaryCollection;
import com.oracle.bmc.aidocument.requests.AddModelLockRequest;
import com.oracle.bmc.aidocument.requests.AddProjectLockRequest;
import com.oracle.bmc.aidocument.requests.AnalyzeDocumentRequest;
import com.oracle.bmc.aidocument.requests.CancelProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.CancelWorkRequestRequest;
import com.oracle.bmc.aidocument.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.aidocument.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.aidocument.requests.CreateModelRequest;
import com.oracle.bmc.aidocument.requests.CreateProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.CreateProjectRequest;
import com.oracle.bmc.aidocument.requests.DeleteModelRequest;
import com.oracle.bmc.aidocument.requests.DeleteProjectRequest;
import com.oracle.bmc.aidocument.requests.GetModelRequest;
import com.oracle.bmc.aidocument.requests.GetProcessorJobRequest;
import com.oracle.bmc.aidocument.requests.GetProjectRequest;
import com.oracle.bmc.aidocument.requests.GetWorkRequestRequest;
import com.oracle.bmc.aidocument.requests.ListModelsRequest;
import com.oracle.bmc.aidocument.requests.ListProjectsRequest;
import com.oracle.bmc.aidocument.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.aidocument.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.aidocument.requests.ListWorkRequestsRequest;
import com.oracle.bmc.aidocument.requests.PatchModelRequest;
import com.oracle.bmc.aidocument.requests.RemoveModelLockRequest;
import com.oracle.bmc.aidocument.requests.RemoveProjectLockRequest;
import com.oracle.bmc.aidocument.requests.UpdateModelRequest;
import com.oracle.bmc.aidocument.requests.UpdateProjectRequest;
import com.oracle.bmc.aidocument.responses.AddModelLockResponse;
import com.oracle.bmc.aidocument.responses.AddProjectLockResponse;
import com.oracle.bmc.aidocument.responses.AnalyzeDocumentResponse;
import com.oracle.bmc.aidocument.responses.CancelProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.CancelWorkRequestResponse;
import com.oracle.bmc.aidocument.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.aidocument.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.aidocument.responses.CreateModelResponse;
import com.oracle.bmc.aidocument.responses.CreateProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.CreateProjectResponse;
import com.oracle.bmc.aidocument.responses.DeleteModelResponse;
import com.oracle.bmc.aidocument.responses.DeleteProjectResponse;
import com.oracle.bmc.aidocument.responses.GetModelResponse;
import com.oracle.bmc.aidocument.responses.GetProcessorJobResponse;
import com.oracle.bmc.aidocument.responses.GetProjectResponse;
import com.oracle.bmc.aidocument.responses.GetWorkRequestResponse;
import com.oracle.bmc.aidocument.responses.ListModelsResponse;
import com.oracle.bmc.aidocument.responses.ListProjectsResponse;
import com.oracle.bmc.aidocument.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.aidocument.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.aidocument.responses.ListWorkRequestsResponse;
import com.oracle.bmc.aidocument.responses.PatchModelResponse;
import com.oracle.bmc.aidocument.responses.RemoveModelLockResponse;
import com.oracle.bmc.aidocument.responses.RemoveProjectLockResponse;
import com.oracle.bmc.aidocument.responses.UpdateModelResponse;
import com.oracle.bmc.aidocument.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceDocumentAsyncClient
extends BaseAsyncClient
implements AIServiceDocumentAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICEDOCUMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://document.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceDocumentAsyncClient.class);

    AIServiceDocumentAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AddModelLockResponse> addModelLock(AddModelLockRequest request, AsyncHandler<AddModelLockRequest, AddModelLockResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddModelLockDetails(), "addModelLockDetails is required");
        return this.clientCall(request, AddModelLockResponse::builder).logger(LOG, "addModelLock").serviceDetails("AIServiceDocument", "AddModelLock", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/AddModelLock").method(Method.POST).requestBuilder(AddModelLockRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("addLock").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Model.class, AddModelLockResponse.Builder::model).handleResponseHeaderString("etag", AddModelLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddModelLockResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AddProjectLockResponse> addProjectLock(AddProjectLockRequest request, AsyncHandler<AddProjectLockRequest, AddProjectLockResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddProjectLockDetails(), "addProjectLockDetails is required");
        return this.clientCall(request, AddProjectLockResponse::builder).logger(LOG, "addProjectLock").serviceDetails("AIServiceDocument", "AddProjectLock", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/AddProjectLock").method(Method.POST).requestBuilder(AddProjectLockRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("addLock").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Project.class, AddProjectLockResponse.Builder::project).handleResponseHeaderString("etag", AddProjectLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AddProjectLockResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AnalyzeDocumentResponse> analyzeDocument(AnalyzeDocumentRequest request, AsyncHandler<AnalyzeDocumentRequest, AnalyzeDocumentResponse> handler) {
        Objects.requireNonNull(request.getAnalyzeDocumentDetails(), "analyzeDocumentDetails is required");
        return this.clientCall(request, AnalyzeDocumentResponse::builder).logger(LOG, "analyzeDocument").serviceDetails("AIServiceDocument", "AnalyzeDocument", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/AnalyzeDocumentResult/AnalyzeDocument").method(Method.POST).requestBuilder(AnalyzeDocumentRequest::builder).basePath("/20221109").appendPathParam("actions").appendPathParam("analyzeDocument").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AnalyzeDocumentResult.class, AnalyzeDocumentResponse.Builder::analyzeDocumentResult).handleResponseHeaderString("Content-Location", AnalyzeDocumentResponse.Builder::contentLocation).handleResponseHeaderString("location", AnalyzeDocumentResponse.Builder::location).handleResponseHeaderString("etag", AnalyzeDocumentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AnalyzeDocumentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelProcessorJobResponse> cancelProcessorJob(CancelProcessorJobRequest request, AsyncHandler<CancelProcessorJobRequest, CancelProcessorJobResponse> handler) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelProcessorJobResponse::builder).logger(LOG, "cancelProcessorJob").serviceDetails("AIServiceDocument", "CancelProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/CancelProcessorJob").method(Method.POST).requestBuilder(CancelProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelProcessorJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("AIServiceDocument", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request, AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeModelCompartmentDetails(), "changeModelCompartmentDetails is required");
        return this.clientCall(request, ChangeModelCompartmentResponse::builder).logger(LOG, "changeModelCompartment").serviceDetails("AIServiceDocument", "ChangeModelCompartment", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/ChangeModelCompartment").method(Method.POST).requestBuilder(ChangeModelCompartmentRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeModelCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("AIServiceDocument", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateModelResponse> createModel(CreateModelRequest request, AsyncHandler<CreateModelRequest, CreateModelResponse> handler) {
        Objects.requireNonNull(request.getCreateModelDetails(), "createModelDetails is required");
        return this.clientCall(request, CreateModelResponse::builder).logger(LOG, "createModel").serviceDetails("AIServiceDocument", "CreateModel", "").method(Method.POST).requestBuilder(CreateModelRequest::builder).basePath("/20221109").appendPathParam("models").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Model.class, CreateModelResponse.Builder::model).handleResponseHeaderString("Content-Location", CreateModelResponse.Builder::contentLocation).handleResponseHeaderString("location", CreateModelResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateModelResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateModelResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateProcessorJobResponse> createProcessorJob(CreateProcessorJobRequest request, AsyncHandler<CreateProcessorJobRequest, CreateProcessorJobResponse> handler) {
        Objects.requireNonNull(request.getCreateProcessorJobDetails(), "createProcessorJobDetails is required");
        return this.clientCall(request, CreateProcessorJobResponse::builder).logger(LOG, "createProcessorJob").serviceDetails("AIServiceDocument", "CreateProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/CreateProcessorJob").method(Method.POST).requestBuilder(CreateProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ProcessorJob.class, CreateProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("opc-request-id", CreateProcessorJobResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateProcessorJobResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("AIServiceDocument", "CreateProject", "").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20221109").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("Content-Location", CreateProjectResponse.Builder::contentLocation).handleResponseHeaderString("location", CreateProjectResponse.Builder::location).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteModelResponse> deleteModel(DeleteModelRequest request, AsyncHandler<DeleteModelRequest, DeleteModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteModelResponse::builder).logger(LOG, "deleteModel").serviceDetails("AIServiceDocument", "DeleteModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/DeleteModel").method(Method.DELETE).requestBuilder(DeleteModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("AIServiceDocument", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetModelResponse> getModel(GetModelRequest request, AsyncHandler<GetModelRequest, GetModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetModelResponse::builder).logger(LOG, "getModel").serviceDetails("AIServiceDocument", "GetModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/GetModel").method(Method.GET).requestBuilder(GetModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Model.class, GetModelResponse.Builder::model).handleResponseHeaderString("etag", GetModelResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProcessorJobResponse> getProcessorJob(GetProcessorJobRequest request, AsyncHandler<GetProcessorJobRequest, GetProcessorJobResponse> handler) {
        Validate.notBlank((String)request.getProcessorJobId(), (String)"processorJobId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProcessorJobResponse::builder).logger(LOG, "getProcessorJob").serviceDetails("AIServiceDocument", "GetProcessorJob", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/ProcessorJob/GetProcessorJob").method(Method.GET).requestBuilder(GetProcessorJobRequest::builder).basePath("/20221109").appendPathParam("processorJobs").appendPathParam(request.getProcessorJobId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProcessorJob.class, GetProcessorJobResponse.Builder::processorJob).handleResponseHeaderString("etag", GetProcessorJobResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProcessorJobResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("AIServiceDocument", "GetProject", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("AIServiceDocument", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderInteger("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListModelsResponse> listModels(ListModelsRequest request, AsyncHandler<ListModelsRequest, ListModelsResponse> handler) {
        return this.clientCall(request, ListModelsResponse::builder).logger(LOG, "listModels").serviceDetails("AIServiceDocument", "ListModels", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/ListModels").method(Method.GET).requestBuilder(ListModelsRequest::builder).basePath("/20221109").appendPathParam("models").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ModelCollection.class, ListModelsResponse.Builder::modelCollection).handleResponseHeaderString("opc-request-id", ListModelsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListModelsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        return this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("AIServiceDocument", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20221109").appendPathParam("projects").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("AIServiceDocument", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("AIServiceDocument", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("AIServiceDocument", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20221109").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PatchModelResponse> patchModel(PatchModelRequest request, AsyncHandler<PatchModelRequest, PatchModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchModelDetails(), "patchModelDetails is required");
        return this.clientCall(request, PatchModelResponse::builder).logger(LOG, "patchModel").serviceDetails("AIServiceDocument", "PatchModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/PatchModel").method(Method.PATCH).requestBuilder(PatchModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(PatchResponseMessage.class, PatchModelResponse.Builder::patchResponseMessage).handleResponseHeaderString("opc-work-request-id", PatchModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PatchModelResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PatchModelResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<RemoveModelLockResponse> removeModelLock(RemoveModelLockRequest request, AsyncHandler<RemoveModelLockRequest, RemoveModelLockResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveModelLockDetails(), "removeModelLockDetails is required");
        return this.clientCall(request, RemoveModelLockResponse::builder).logger(LOG, "removeModelLock").serviceDetails("AIServiceDocument", "RemoveModelLock", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/RemoveModelLock").method(Method.POST).requestBuilder(RemoveModelLockRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).appendPathParam("actions").appendPathParam("removeLock").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Model.class, RemoveModelLockResponse.Builder::model).handleResponseHeaderString("etag", RemoveModelLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveModelLockResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveProjectLockResponse> removeProjectLock(RemoveProjectLockRequest request, AsyncHandler<RemoveProjectLockRequest, RemoveProjectLockResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveProjectLockDetails(), "removeProjectLockDetails is required");
        return this.clientCall(request, RemoveProjectLockResponse::builder).logger(LOG, "removeProjectLock").serviceDetails("AIServiceDocument", "RemoveProjectLock", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/RemoveProjectLock").method(Method.POST).requestBuilder(RemoveProjectLockRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("removeLock").appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Project.class, RemoveProjectLockResponse.Builder::project).handleResponseHeaderString("etag", RemoveProjectLockResponse.Builder::etag).handleResponseHeaderString("opc-request-id", RemoveProjectLockResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateModelResponse> updateModel(UpdateModelRequest request, AsyncHandler<UpdateModelRequest, UpdateModelResponse> handler) {
        Validate.notBlank((String)request.getModelId(), (String)"modelId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateModelDetails(), "updateModelDetails is required");
        return this.clientCall(request, UpdateModelResponse::builder).logger(LOG, "updateModel").serviceDetails("AIServiceDocument", "UpdateModel", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Model/UpdateModel").method(Method.PUT).requestBuilder(UpdateModelRequest::builder).basePath("/20221109").appendPathParam("models").appendPathParam(request.getModelId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateModelResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateModelResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("AIServiceDocument", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/document-understanding/20221109/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20221109").appendPathParam("projects").appendPathParam(request.getProjectId()).appendQueryParam("isLockOverride", (Object)request.getIsLockOverride()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)AIServiceDocumentAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(AIServiceDocumentAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public AIServiceDocumentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)AIServiceDocumentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceDocumentAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "aidocument";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"aidocument");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AIServiceDocumentAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new AIServiceDocumentAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

