/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aidocument.model.DocumentClassificationConfidenceEntry;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DocumentClassificationLabelMetricsReport
extends ExplicitlySetBmcModel {
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="meanAveragePrecision")
    private final Float meanAveragePrecision;
    @JsonProperty(value="confidenceEntries")
    private final List<DocumentClassificationConfidenceEntry> confidenceEntries;

    @Deprecated
    @ConstructorProperties(value={"label", "meanAveragePrecision", "confidenceEntries"})
    public DocumentClassificationLabelMetricsReport(String label, Float meanAveragePrecision, List<DocumentClassificationConfidenceEntry> confidenceEntries) {
        this.label = label;
        this.meanAveragePrecision = meanAveragePrecision;
        this.confidenceEntries = confidenceEntries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLabel() {
        return this.label;
    }

    public Float getMeanAveragePrecision() {
        return this.meanAveragePrecision;
    }

    public List<DocumentClassificationConfidenceEntry> getConfidenceEntries() {
        return this.confidenceEntries;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DocumentClassificationLabelMetricsReport(");
        sb.append("super=").append(super.toString());
        sb.append("label=").append(String.valueOf(this.label));
        sb.append(", meanAveragePrecision=").append(String.valueOf(this.meanAveragePrecision));
        sb.append(", confidenceEntries=").append(String.valueOf(this.confidenceEntries));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentClassificationLabelMetricsReport)) {
            return false;
        }
        DocumentClassificationLabelMetricsReport other = (DocumentClassificationLabelMetricsReport)((Object)o);
        return Objects.equals(this.label, other.label) && Objects.equals(this.meanAveragePrecision, other.meanAveragePrecision) && Objects.equals(this.confidenceEntries, other.confidenceEntries) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.meanAveragePrecision == null ? 43 : this.meanAveragePrecision.hashCode());
        result = result * 59 + (this.confidenceEntries == null ? 43 : this.confidenceEntries.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="meanAveragePrecision")
        private Float meanAveragePrecision;
        @JsonProperty(value="confidenceEntries")
        private List<DocumentClassificationConfidenceEntry> confidenceEntries;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder meanAveragePrecision(Float meanAveragePrecision) {
            this.meanAveragePrecision = meanAveragePrecision;
            this.__explicitlySet__.add("meanAveragePrecision");
            return this;
        }

        public Builder confidenceEntries(List<DocumentClassificationConfidenceEntry> confidenceEntries) {
            this.confidenceEntries = confidenceEntries;
            this.__explicitlySet__.add("confidenceEntries");
            return this;
        }

        public DocumentClassificationLabelMetricsReport build() {
            DocumentClassificationLabelMetricsReport model = new DocumentClassificationLabelMetricsReport(this.label, this.meanAveragePrecision, this.confidenceEntries);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DocumentClassificationLabelMetricsReport model) {
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("meanAveragePrecision")) {
                this.meanAveragePrecision(model.getMeanAveragePrecision());
            }
            if (model.wasPropertyExplicitlySet("confidenceEntries")) {
                this.confidenceEntries(model.getConfidenceEntries());
            }
            return this;
        }
    }
}

