/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.aidocument.model.DatasetSummary;
import com.oracle.bmc.aidocument.model.DocumentClassificationLabelMetricsReport;
import com.oracle.bmc.aidocument.model.DocumentClassificationOverallMetricsReport;
import com.oracle.bmc.aidocument.model.ModelMetrics;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="modelType")
@JsonFilter(value="explicitlySetFilter")
public final class DocumentClassificationModelMetrics
extends ModelMetrics {
    @JsonProperty(value="labelMetricsReport")
    private final List<DocumentClassificationLabelMetricsReport> labelMetricsReport;
    @JsonProperty(value="overallMetricsReport")
    private final DocumentClassificationOverallMetricsReport overallMetricsReport;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DocumentClassificationModelMetrics(DatasetSummary datasetSummary, List<DocumentClassificationLabelMetricsReport> labelMetricsReport, DocumentClassificationOverallMetricsReport overallMetricsReport) {
        super(datasetSummary);
        this.labelMetricsReport = labelMetricsReport;
        this.overallMetricsReport = overallMetricsReport;
    }

    public List<DocumentClassificationLabelMetricsReport> getLabelMetricsReport() {
        return this.labelMetricsReport;
    }

    public DocumentClassificationOverallMetricsReport getOverallMetricsReport() {
        return this.overallMetricsReport;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DocumentClassificationModelMetrics(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", labelMetricsReport=").append(String.valueOf(this.labelMetricsReport));
        sb.append(", overallMetricsReport=").append(String.valueOf((Object)this.overallMetricsReport));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentClassificationModelMetrics)) {
            return false;
        }
        DocumentClassificationModelMetrics other = (DocumentClassificationModelMetrics)((Object)o);
        return Objects.equals(this.labelMetricsReport, other.labelMetricsReport) && Objects.equals((Object)this.overallMetricsReport, (Object)other.overallMetricsReport) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.labelMetricsReport == null ? 43 : this.labelMetricsReport.hashCode());
        result = result * 59 + (this.overallMetricsReport == null ? 43 : this.overallMetricsReport.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="datasetSummary")
        private DatasetSummary datasetSummary;
        @JsonProperty(value="labelMetricsReport")
        private List<DocumentClassificationLabelMetricsReport> labelMetricsReport;
        @JsonProperty(value="overallMetricsReport")
        private DocumentClassificationOverallMetricsReport overallMetricsReport;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder datasetSummary(DatasetSummary datasetSummary) {
            this.datasetSummary = datasetSummary;
            this.__explicitlySet__.add("datasetSummary");
            return this;
        }

        public Builder labelMetricsReport(List<DocumentClassificationLabelMetricsReport> labelMetricsReport) {
            this.labelMetricsReport = labelMetricsReport;
            this.__explicitlySet__.add("labelMetricsReport");
            return this;
        }

        public Builder overallMetricsReport(DocumentClassificationOverallMetricsReport overallMetricsReport) {
            this.overallMetricsReport = overallMetricsReport;
            this.__explicitlySet__.add("overallMetricsReport");
            return this;
        }

        public DocumentClassificationModelMetrics build() {
            DocumentClassificationModelMetrics model = new DocumentClassificationModelMetrics(this.datasetSummary, this.labelMetricsReport, this.overallMetricsReport);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DocumentClassificationModelMetrics model) {
            if (model.wasPropertyExplicitlySet("datasetSummary")) {
                this.datasetSummary(model.getDatasetSummary());
            }
            if (model.wasPropertyExplicitlySet("labelMetricsReport")) {
                this.labelMetricsReport(model.getLabelMetricsReport());
            }
            if (model.wasPropertyExplicitlySet("overallMetricsReport")) {
                this.overallMetricsReport(model.getOverallMetricsReport());
            }
            return this;
        }
    }
}

