/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.aidocument.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.aidocument.model.UpdateProjectDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateProjectRequest
extends BmcRequest<UpdateProjectDetails> {
    private String projectId;
    private UpdateProjectDetails updateProjectDetails;
    private String ifMatch;
    private String opcRequestId;
    private Boolean isLockOverride;

    public String getProjectId() {
        return this.projectId;
    }

    public UpdateProjectDetails getUpdateProjectDetails() {
        return this.updateProjectDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Boolean getIsLockOverride() {
        return this.isLockOverride;
    }

    @InternalSdk
    public UpdateProjectDetails getBody$() {
        return this.updateProjectDetails;
    }

    public Builder toBuilder() {
        return new Builder().projectId(this.projectId).updateProjectDetails(this.updateProjectDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).isLockOverride(this.isLockOverride);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",projectId=").append(String.valueOf(this.projectId));
        sb.append(",updateProjectDetails=").append(String.valueOf((Object)this.updateProjectDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",isLockOverride=").append(String.valueOf(this.isLockOverride));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.projectId, other.projectId) && Objects.equals((Object)this.updateProjectDetails, (Object)other.updateProjectDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.isLockOverride, other.isLockOverride);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.updateProjectDetails == null ? 43 : this.updateProjectDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.isLockOverride == null ? 43 : this.isLockOverride.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProjectRequest, UpdateProjectDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String projectId = null;
        private UpdateProjectDetails updateProjectDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private Boolean isLockOverride = null;

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder updateProjectDetails(UpdateProjectDetails updateProjectDetails) {
            this.updateProjectDetails = updateProjectDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder isLockOverride(Boolean isLockOverride) {
            this.isLockOverride = isLockOverride;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProjectRequest o) {
            this.projectId(o.getProjectId());
            this.updateProjectDetails(o.getUpdateProjectDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.isLockOverride(o.getIsLockOverride());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProjectRequest build() {
            UpdateProjectRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateProjectDetails body) {
            this.updateProjectDetails(body);
            return this;
        }

        public UpdateProjectRequest buildWithoutInvocationCallback() {
            UpdateProjectRequest request = new UpdateProjectRequest();
            request.projectId = this.projectId;
            request.updateProjectDetails = this.updateProjectDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.isLockOverride = this.isLockOverride;
            return request;
        }
    }
}

