/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.ailanguage.AIServiceLanguageAsync;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectDominantLanguageConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageKeyPhrasesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageSentimentsConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageTextClassificationConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectDominantLanguageConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageKeyPhrasesConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageSentimentsConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageTextClassificationConverter;
import com.oracle.bmc.ailanguage.requests.BatchDetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.requests.DetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.responses.BatchDetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageTextClassificationResponse;
import com.oracle.bmc.ailanguage.responses.DetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageTextClassificationResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceLanguageAsyncClient
implements AIServiceLanguageAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICELANGUAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://language.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceLanguageAsyncClient.class);
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    public AIServiceLanguageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AIServiceLanguageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AIServiceLanguageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.clientConfigurationToUse = configuration;
        this.refreshClient();
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    RestClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = GuavaUtils.adaptFromGuava((com.google.common.base.Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(BatchDetectDominantLanguageRequest request, AsyncHandler<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse> handler) {
        LOG.trace("Called async batchDetectDominantLanguage");
        BatchDetectDominantLanguageRequest interceptedRequest = BatchDetectDominantLanguageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectDominantLanguageConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectDominantLanguage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/BatchDetectDominantLanguage/BatchDetectDominantLanguage");
        Function<Response, BatchDetectDominantLanguageResponse> transformer = BatchDetectDominantLanguageConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectDominantLanguageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageEntitiesResponse> batchDetectLanguageEntities(BatchDetectLanguageEntitiesRequest request, AsyncHandler<BatchDetectLanguageEntitiesRequest, BatchDetectLanguageEntitiesResponse> handler) {
        LOG.trace("Called async batchDetectLanguageEntities");
        BatchDetectLanguageEntitiesRequest interceptedRequest = BatchDetectLanguageEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageEntitiesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/BatchDetectLanguageEntities/BatchDetectLanguageEntities");
        Function<Response, BatchDetectLanguageEntitiesResponse> transformer = BatchDetectLanguageEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageEntitiesRequest, BatchDetectLanguageEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageEntitiesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageEntitiesRequest, BatchDetectLanguageEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageKeyPhrasesResponse> batchDetectLanguageKeyPhrases(BatchDetectLanguageKeyPhrasesRequest request, AsyncHandler<BatchDetectLanguageKeyPhrasesRequest, BatchDetectLanguageKeyPhrasesResponse> handler) {
        LOG.trace("Called async batchDetectLanguageKeyPhrases");
        BatchDetectLanguageKeyPhrasesRequest interceptedRequest = BatchDetectLanguageKeyPhrasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageKeyPhrasesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageKeyPhrases", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/BatchDetectLanguageKeyPhrases/BatchDetectLanguageKeyPhrases");
        Function<Response, BatchDetectLanguageKeyPhrasesResponse> transformer = BatchDetectLanguageKeyPhrasesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageKeyPhrasesRequest, BatchDetectLanguageKeyPhrasesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageKeyPhrasesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageKeyPhrasesRequest, BatchDetectLanguageKeyPhrasesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageSentimentsResponse> batchDetectLanguageSentiments(BatchDetectLanguageSentimentsRequest request, AsyncHandler<BatchDetectLanguageSentimentsRequest, BatchDetectLanguageSentimentsResponse> handler) {
        LOG.trace("Called async batchDetectLanguageSentiments");
        BatchDetectLanguageSentimentsRequest interceptedRequest = BatchDetectLanguageSentimentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageSentimentsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageSentiments", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/BatchDetectLanguageSentiments/BatchDetectLanguageSentiments");
        Function<Response, BatchDetectLanguageSentimentsResponse> transformer = BatchDetectLanguageSentimentsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageSentimentsRequest, BatchDetectLanguageSentimentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageSentimentsDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageSentimentsRequest, BatchDetectLanguageSentimentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageTextClassificationResponse> batchDetectLanguageTextClassification(BatchDetectLanguageTextClassificationRequest request, AsyncHandler<BatchDetectLanguageTextClassificationRequest, BatchDetectLanguageTextClassificationResponse> handler) {
        LOG.trace("Called async batchDetectLanguageTextClassification");
        BatchDetectLanguageTextClassificationRequest interceptedRequest = BatchDetectLanguageTextClassificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageTextClassificationConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageTextClassification", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/BatchDetectLanguageTextClassification/BatchDetectLanguageTextClassification");
        Function<Response, BatchDetectLanguageTextClassificationResponse> transformer = BatchDetectLanguageTextClassificationConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageTextClassificationRequest, BatchDetectLanguageTextClassificationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageTextClassificationDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageTextClassificationRequest, BatchDetectLanguageTextClassificationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectDominantLanguageResponse> detectDominantLanguage(DetectDominantLanguageRequest request, AsyncHandler<DetectDominantLanguageRequest, DetectDominantLanguageResponse> handler) {
        LOG.trace("Called async detectDominantLanguage");
        DetectDominantLanguageRequest interceptedRequest = DetectDominantLanguageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectDominantLanguageConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectDominantLanguage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/DetectDominantLanguage/DetectDominantLanguage");
        Function<Response, DetectDominantLanguageResponse> transformer = DetectDominantLanguageConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectDominantLanguageRequest, DetectDominantLanguageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectDominantLanguageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectDominantLanguageRequest, DetectDominantLanguageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageEntitiesResponse> detectLanguageEntities(DetectLanguageEntitiesRequest request, AsyncHandler<DetectLanguageEntitiesRequest, DetectLanguageEntitiesResponse> handler) {
        LOG.trace("Called async detectLanguageEntities");
        DetectLanguageEntitiesRequest interceptedRequest = DetectLanguageEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageEntitiesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/DetectLanguageEntities/DetectLanguageEntities");
        Function<Response, DetectLanguageEntitiesResponse> transformer = DetectLanguageEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageEntitiesRequest, DetectLanguageEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageEntitiesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageEntitiesRequest, DetectLanguageEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageKeyPhrasesResponse> detectLanguageKeyPhrases(DetectLanguageKeyPhrasesRequest request, AsyncHandler<DetectLanguageKeyPhrasesRequest, DetectLanguageKeyPhrasesResponse> handler) {
        LOG.trace("Called async detectLanguageKeyPhrases");
        DetectLanguageKeyPhrasesRequest interceptedRequest = DetectLanguageKeyPhrasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageKeyPhrasesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageKeyPhrases", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/DetectLanguageKeyPhrases/DetectLanguageKeyPhrases");
        Function<Response, DetectLanguageKeyPhrasesResponse> transformer = DetectLanguageKeyPhrasesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageKeyPhrasesRequest, DetectLanguageKeyPhrasesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageKeyPhrasesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageKeyPhrasesRequest, DetectLanguageKeyPhrasesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageSentimentsResponse> detectLanguageSentiments(DetectLanguageSentimentsRequest request, AsyncHandler<DetectLanguageSentimentsRequest, DetectLanguageSentimentsResponse> handler) {
        LOG.trace("Called async detectLanguageSentiments");
        DetectLanguageSentimentsRequest interceptedRequest = DetectLanguageSentimentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageSentimentsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageSentiments", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/DetectLanguageSentiments/DetectLanguageSentiments");
        Function<Response, DetectLanguageSentimentsResponse> transformer = DetectLanguageSentimentsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageSentimentsRequest, DetectLanguageSentimentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageSentimentsDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageSentimentsRequest, DetectLanguageSentimentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageTextClassificationResponse> detectLanguageTextClassification(DetectLanguageTextClassificationRequest request, AsyncHandler<DetectLanguageTextClassificationRequest, DetectLanguageTextClassificationResponse> handler) {
        LOG.trace("Called async detectLanguageTextClassification");
        DetectLanguageTextClassificationRequest interceptedRequest = DetectLanguageTextClassificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageTextClassificationConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageTextClassification", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20210101/DetectLanguageTextClassification/DetectLanguageTextClassification");
        Function<Response, DetectLanguageTextClassificationResponse> transformer = DetectLanguageTextClassificationConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageTextClassificationRequest, DetectLanguageTextClassificationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageTextClassificationDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageTextClassificationRequest, DetectLanguageTextClassificationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceLanguageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AIServiceLanguageAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new AIServiceLanguageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

