/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.ailanguage.model.BatchDetectLanguageKeyPhrasesResult;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDetectLanguageKeyPhrasesConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(BatchDetectLanguageKeyPhrasesConverter.class);

    public static BatchDetectLanguageKeyPhrasesRequest interceptRequest(BatchDetectLanguageKeyPhrasesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, BatchDetectLanguageKeyPhrasesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getBatchDetectLanguageKeyPhrasesDetails()), (String)"batchDetectLanguageKeyPhrasesDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210101").path("actions").path("batchDetectLanguageKeyPhrases");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, BatchDetectLanguageKeyPhrasesResponse> fromResponse() {
        return BatchDetectLanguageKeyPhrasesConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, BatchDetectLanguageKeyPhrasesResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, BatchDetectLanguageKeyPhrasesResponse> transformer = new Function<Response, BatchDetectLanguageKeyPhrasesResponse>(){

            @Override
            public BatchDetectLanguageKeyPhrasesResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.ailanguage.responses.BatchDetectLanguageKeyPhrasesResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(BatchDetectLanguageKeyPhrasesResult.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(BatchDetectLanguageKeyPhrasesResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                BatchDetectLanguageKeyPhrasesResponse.Builder builder = BatchDetectLanguageKeyPhrasesResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.batchDetectLanguageKeyPhrasesResult((BatchDetectLanguageKeyPhrasesResult)((Object)response.getItem()));
                Optional opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                BatchDetectLanguageKeyPhrasesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

