/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.ailanguage.model.DetectLanguageTextClassificationResult;
import com.oracle.bmc.ailanguage.requests.DetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.responses.DetectLanguageTextClassificationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectLanguageTextClassificationConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(DetectLanguageTextClassificationConverter.class);

    public static DetectLanguageTextClassificationRequest interceptRequest(DetectLanguageTextClassificationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, DetectLanguageTextClassificationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getDetectLanguageTextClassificationDetails()), (String)"detectLanguageTextClassificationDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20210101").path("actions").path("detectLanguageTextClassification");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, DetectLanguageTextClassificationResponse> fromResponse() {
        return DetectLanguageTextClassificationConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, DetectLanguageTextClassificationResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, DetectLanguageTextClassificationResponse> transformer = new Function<Response, DetectLanguageTextClassificationResponse>(){

            @Override
            public DetectLanguageTextClassificationResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.ailanguage.responses.DetectLanguageTextClassificationResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(DetectLanguageTextClassificationResult.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(DetectLanguageTextClassificationResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                DetectLanguageTextClassificationResponse.Builder builder = DetectLanguageTextClassificationResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.detectLanguageTextClassificationResult((DetectLanguageTextClassificationResult)((Object)response.getItem()));
                Optional opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                DetectLanguageTextClassificationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

