/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Entity
extends ExplicitlySetBmcModel {
    @JsonProperty(value="offset")
    private final Integer offset;
    @JsonProperty(value="length")
    private final Integer length;
    @JsonProperty(value="text")
    private final String text;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="isPii")
    private final Boolean isPii;
    @JsonProperty(value="score")
    private final Double score;

    @Deprecated
    @ConstructorProperties(value={"offset", "length", "text", "type", "isPii", "score"})
    public Entity(Integer offset, Integer length, String text, String type, Boolean isPii, Double score) {
        this.offset = offset;
        this.length = length;
        this.text = text;
        this.type = type;
        this.isPii = isPii;
        this.score = score;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLength() {
        return this.length;
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getIsPii() {
        return this.isPii;
    }

    public Double getScore() {
        return this.score;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Entity(");
        sb.append("super=").append(super.toString());
        sb.append("offset=").append(String.valueOf(this.offset));
        sb.append(", length=").append(String.valueOf(this.length));
        sb.append(", text=").append(String.valueOf(this.text));
        sb.append(", type=").append(String.valueOf(this.type));
        sb.append(", isPii=").append(String.valueOf(this.isPii));
        sb.append(", score=").append(String.valueOf(this.score));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)((Object)o);
        return Objects.equals(this.offset, other.offset) && Objects.equals(this.length, other.length) && Objects.equals(this.text, other.text) && Objects.equals(this.type, other.type) && Objects.equals(this.isPii, other.isPii) && Objects.equals(this.score, other.score) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.offset == null ? 43 : this.offset.hashCode());
        result = result * 59 + (this.length == null ? 43 : this.length.hashCode());
        result = result * 59 + (this.text == null ? 43 : this.text.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.isPii == null ? 43 : this.isPii.hashCode());
        result = result * 59 + (this.score == null ? 43 : this.score.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="offset")
        private Integer offset;
        @JsonProperty(value="length")
        private Integer length;
        @JsonProperty(value="text")
        private String text;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="isPii")
        private Boolean isPii;
        @JsonProperty(value="score")
        private Double score;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder offset(Integer offset) {
            this.offset = offset;
            this.__explicitlySet__.add("offset");
            return this;
        }

        public Builder length(Integer length) {
            this.length = length;
            this.__explicitlySet__.add("length");
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            this.__explicitlySet__.add("text");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder isPii(Boolean isPii) {
            this.isPii = isPii;
            this.__explicitlySet__.add("isPii");
            return this;
        }

        public Builder score(Double score) {
            this.score = score;
            this.__explicitlySet__.add("score");
            return this;
        }

        public Entity build() {
            Entity model = new Entity(this.offset, this.length, this.text, this.type, this.isPii, this.score);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Entity model) {
            if (model.wasPropertyExplicitlySet("offset")) {
                this.offset(model.getOffset());
            }
            if (model.wasPropertyExplicitlySet("length")) {
                this.length(model.getLength());
            }
            if (model.wasPropertyExplicitlySet("text")) {
                this.text(model.getText());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("isPii")) {
                this.isPii(model.getIsPii());
            }
            if (model.wasPropertyExplicitlySet("score")) {
                this.score(model.getScore());
            }
            return this;
        }
    }
}

