/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.SentimentAspect;
import com.oracle.bmc.ailanguage.model.SentimentSentence;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SentimentDocumentResult
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="documentSentiment")
    private final String documentSentiment;
    @JsonProperty(value="documentScores")
    private final Map<String, Double> documentScores;
    @JsonProperty(value="aspects")
    private final List<SentimentAspect> aspects;
    @JsonProperty(value="sentences")
    private final List<SentimentSentence> sentences;
    @JsonProperty(value="languageCode")
    private final String languageCode;

    @Deprecated
    @ConstructorProperties(value={"key", "documentSentiment", "documentScores", "aspects", "sentences", "languageCode"})
    public SentimentDocumentResult(String key, String documentSentiment, Map<String, Double> documentScores, List<SentimentAspect> aspects, List<SentimentSentence> sentences, String languageCode) {
        this.key = key;
        this.documentSentiment = documentSentiment;
        this.documentScores = documentScores;
        this.aspects = aspects;
        this.sentences = sentences;
        this.languageCode = languageCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getDocumentSentiment() {
        return this.documentSentiment;
    }

    public Map<String, Double> getDocumentScores() {
        return this.documentScores;
    }

    public List<SentimentAspect> getAspects() {
        return this.aspects;
    }

    public List<SentimentSentence> getSentences() {
        return this.sentences;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SentimentDocumentResult(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", documentSentiment=").append(String.valueOf(this.documentSentiment));
        sb.append(", documentScores=").append(String.valueOf(this.documentScores));
        sb.append(", aspects=").append(String.valueOf(this.aspects));
        sb.append(", sentences=").append(String.valueOf(this.sentences));
        sb.append(", languageCode=").append(String.valueOf(this.languageCode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SentimentDocumentResult)) {
            return false;
        }
        SentimentDocumentResult other = (SentimentDocumentResult)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.documentSentiment, other.documentSentiment) && Objects.equals(this.documentScores, other.documentScores) && Objects.equals(this.aspects, other.aspects) && Objects.equals(this.sentences, other.sentences) && Objects.equals(this.languageCode, other.languageCode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.documentSentiment == null ? 43 : this.documentSentiment.hashCode());
        result = result * 59 + (this.documentScores == null ? 43 : this.documentScores.hashCode());
        result = result * 59 + (this.aspects == null ? 43 : this.aspects.hashCode());
        result = result * 59 + (this.sentences == null ? 43 : this.sentences.hashCode());
        result = result * 59 + (this.languageCode == null ? 43 : this.languageCode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="documentSentiment")
        private String documentSentiment;
        @JsonProperty(value="documentScores")
        private Map<String, Double> documentScores;
        @JsonProperty(value="aspects")
        private List<SentimentAspect> aspects;
        @JsonProperty(value="sentences")
        private List<SentimentSentence> sentences;
        @JsonProperty(value="languageCode")
        private String languageCode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder documentSentiment(String documentSentiment) {
            this.documentSentiment = documentSentiment;
            this.__explicitlySet__.add("documentSentiment");
            return this;
        }

        public Builder documentScores(Map<String, Double> documentScores) {
            this.documentScores = documentScores;
            this.__explicitlySet__.add("documentScores");
            return this;
        }

        public Builder aspects(List<SentimentAspect> aspects) {
            this.aspects = aspects;
            this.__explicitlySet__.add("aspects");
            return this;
        }

        public Builder sentences(List<SentimentSentence> sentences) {
            this.sentences = sentences;
            this.__explicitlySet__.add("sentences");
            return this;
        }

        public Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            this.__explicitlySet__.add("languageCode");
            return this;
        }

        public SentimentDocumentResult build() {
            SentimentDocumentResult model = new SentimentDocumentResult(this.key, this.documentSentiment, this.documentScores, this.aspects, this.sentences, this.languageCode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SentimentDocumentResult model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("documentSentiment")) {
                this.documentSentiment(model.getDocumentSentiment());
            }
            if (model.wasPropertyExplicitlySet("documentScores")) {
                this.documentScores(model.getDocumentScores());
            }
            if (model.wasPropertyExplicitlySet("aspects")) {
                this.aspects(model.getAspects());
            }
            if (model.wasPropertyExplicitlySet("sentences")) {
                this.sentences(model.getSentences());
            }
            if (model.wasPropertyExplicitlySet("languageCode")) {
                this.languageCode(model.getLanguageCode());
            }
            return this;
        }
    }
}

