/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.ailanguage.AIServiceLanguage;
import com.oracle.bmc.ailanguage.AIServiceLanguageAsyncClient;
import com.oracle.bmc.ailanguage.AIServiceLanguagePaginators;
import com.oracle.bmc.ailanguage.AIServiceLanguageWaiters;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectDominantLanguageConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageKeyPhrasesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguagePiiEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageSentimentsConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageTextClassificationConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchLanguageTranslationConverter;
import com.oracle.bmc.ailanguage.internal.http.ChangeEndpointCompartmentConverter;
import com.oracle.bmc.ailanguage.internal.http.ChangeModelCompartmentConverter;
import com.oracle.bmc.ailanguage.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.ailanguage.internal.http.CreateEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.CreateModelConverter;
import com.oracle.bmc.ailanguage.internal.http.CreateProjectConverter;
import com.oracle.bmc.ailanguage.internal.http.DeleteEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.DeleteModelConverter;
import com.oracle.bmc.ailanguage.internal.http.DeleteProjectConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectDominantLanguageConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageKeyPhrasesConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageSentimentsConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageTextClassificationConverter;
import com.oracle.bmc.ailanguage.internal.http.GetEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.GetModelConverter;
import com.oracle.bmc.ailanguage.internal.http.GetProjectConverter;
import com.oracle.bmc.ailanguage.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.ailanguage.internal.http.ListEndpointsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListEvaluationResultsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListModelsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListProjectsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.ailanguage.internal.http.UpdateEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.UpdateModelConverter;
import com.oracle.bmc.ailanguage.internal.http.UpdateProjectConverter;
import com.oracle.bmc.ailanguage.requests.BatchDetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguagePiiEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.requests.BatchLanguageTranslationRequest;
import com.oracle.bmc.ailanguage.requests.ChangeEndpointCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.CreateEndpointRequest;
import com.oracle.bmc.ailanguage.requests.CreateModelRequest;
import com.oracle.bmc.ailanguage.requests.CreateProjectRequest;
import com.oracle.bmc.ailanguage.requests.DeleteEndpointRequest;
import com.oracle.bmc.ailanguage.requests.DeleteModelRequest;
import com.oracle.bmc.ailanguage.requests.DeleteProjectRequest;
import com.oracle.bmc.ailanguage.requests.DetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.requests.GetEndpointRequest;
import com.oracle.bmc.ailanguage.requests.GetModelRequest;
import com.oracle.bmc.ailanguage.requests.GetProjectRequest;
import com.oracle.bmc.ailanguage.requests.GetWorkRequestRequest;
import com.oracle.bmc.ailanguage.requests.ListEndpointsRequest;
import com.oracle.bmc.ailanguage.requests.ListEvaluationResultsRequest;
import com.oracle.bmc.ailanguage.requests.ListModelsRequest;
import com.oracle.bmc.ailanguage.requests.ListProjectsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.ailanguage.requests.UpdateEndpointRequest;
import com.oracle.bmc.ailanguage.requests.UpdateModelRequest;
import com.oracle.bmc.ailanguage.requests.UpdateProjectRequest;
import com.oracle.bmc.ailanguage.responses.BatchDetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguagePiiEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageTextClassificationResponse;
import com.oracle.bmc.ailanguage.responses.BatchLanguageTranslationResponse;
import com.oracle.bmc.ailanguage.responses.ChangeEndpointCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.CreateEndpointResponse;
import com.oracle.bmc.ailanguage.responses.CreateModelResponse;
import com.oracle.bmc.ailanguage.responses.CreateProjectResponse;
import com.oracle.bmc.ailanguage.responses.DeleteEndpointResponse;
import com.oracle.bmc.ailanguage.responses.DeleteModelResponse;
import com.oracle.bmc.ailanguage.responses.DeleteProjectResponse;
import com.oracle.bmc.ailanguage.responses.DetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageTextClassificationResponse;
import com.oracle.bmc.ailanguage.responses.GetEndpointResponse;
import com.oracle.bmc.ailanguage.responses.GetModelResponse;
import com.oracle.bmc.ailanguage.responses.GetProjectResponse;
import com.oracle.bmc.ailanguage.responses.GetWorkRequestResponse;
import com.oracle.bmc.ailanguage.responses.ListEndpointsResponse;
import com.oracle.bmc.ailanguage.responses.ListEvaluationResultsResponse;
import com.oracle.bmc.ailanguage.responses.ListModelsResponse;
import com.oracle.bmc.ailanguage.responses.ListProjectsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.ailanguage.responses.UpdateEndpointResponse;
import com.oracle.bmc.ailanguage.responses.UpdateModelResponse;
import com.oracle.bmc.ailanguage.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.circuitbreaker.CircuitBreakerConfiguration;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.RetryUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.util.CircuitBreakerUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceLanguageClient
implements AIServiceLanguage {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICELANGUAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://language.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceLanguageAsyncClient.class);
    private final AIServiceLanguageWaiters waiters;
    private final AIServiceLanguagePaginators paginators;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private final CircuitBreakerConfiguration circuitBreakerConfiguration;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    RestClient getClient() {
        return this.client;
    }

    public AIServiceLanguageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AIServiceLanguageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AIServiceLanguageClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected AIServiceLanguageClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.retryConfiguration = this.clientConfigurationToUse.getRetryConfiguration();
        CircuitBreakerConfiguration userCircuitBreakerConfiguration = CircuitBreakerUtils.getUserDefinedCircuitBreakerConfiguration((ClientConfiguration)configuration);
        this.circuitBreakerConfiguration = userCircuitBreakerConfiguration == null ? CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION : userCircuitBreakerConfiguration;
        this.refreshClient();
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("AIServiceLanguage-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new AIServiceLanguageWaiters(executorService, this);
        this.paginators = new AIServiceLanguagePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient, null, this.circuitBreakerConfiguration);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = GuavaUtils.adaptFromGuava((com.google.common.base.Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public BatchDetectDominantLanguageResponse batchDetectDominantLanguage(BatchDetectDominantLanguageRequest request) {
        LOG.trace("Called batchDetectDominantLanguage");
        BatchDetectDominantLanguageRequest interceptedRequest = BatchDetectDominantLanguageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectDominantLanguageConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectDominantLanguage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectDominantLanguage/BatchDetectDominantLanguage");
        Function<Response, BatchDetectDominantLanguageResponse> transformer = BatchDetectDominantLanguageConverter.fromResponse(Optional.of(serviceDetails));
        return (BatchDetectDominantLanguageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchDetectDominantLanguageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBatchDetectDominantLanguageDetails(), (BmcRequest)retriedRequest);
                return (BatchDetectDominantLanguageResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public BatchDetectLanguageEntitiesResponse batchDetectLanguageEntities(BatchDetectLanguageEntitiesRequest request) {
        LOG.trace("Called batchDetectLanguageEntities");
        BatchDetectLanguageEntitiesRequest interceptedRequest = BatchDetectLanguageEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageEntitiesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageEntities/BatchDetectLanguageEntities");
        Function<Response, BatchDetectLanguageEntitiesResponse> transformer = BatchDetectLanguageEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        return (BatchDetectLanguageEntitiesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchDetectLanguageEntitiesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBatchDetectLanguageEntitiesDetails(), (BmcRequest)retriedRequest);
                return (BatchDetectLanguageEntitiesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public BatchDetectLanguageKeyPhrasesResponse batchDetectLanguageKeyPhrases(BatchDetectLanguageKeyPhrasesRequest request) {
        LOG.trace("Called batchDetectLanguageKeyPhrases");
        BatchDetectLanguageKeyPhrasesRequest interceptedRequest = BatchDetectLanguageKeyPhrasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageKeyPhrasesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageKeyPhrases", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageKeyPhrases/BatchDetectLanguageKeyPhrases");
        Function<Response, BatchDetectLanguageKeyPhrasesResponse> transformer = BatchDetectLanguageKeyPhrasesConverter.fromResponse(Optional.of(serviceDetails));
        return (BatchDetectLanguageKeyPhrasesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchDetectLanguageKeyPhrasesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBatchDetectLanguageKeyPhrasesDetails(), (BmcRequest)retriedRequest);
                return (BatchDetectLanguageKeyPhrasesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public BatchDetectLanguagePiiEntitiesResponse batchDetectLanguagePiiEntities(BatchDetectLanguagePiiEntitiesRequest request) {
        LOG.trace("Called batchDetectLanguagePiiEntities");
        BatchDetectLanguagePiiEntitiesRequest interceptedRequest = BatchDetectLanguagePiiEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguagePiiEntitiesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguagePiiEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguagePiiEntities/BatchDetectLanguagePiiEntities");
        Function<Response, BatchDetectLanguagePiiEntitiesResponse> transformer = BatchDetectLanguagePiiEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        return (BatchDetectLanguagePiiEntitiesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchDetectLanguagePiiEntitiesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBatchDetectLanguagePiiEntitiesDetails(), (BmcRequest)retriedRequest);
                return (BatchDetectLanguagePiiEntitiesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public BatchDetectLanguageSentimentsResponse batchDetectLanguageSentiments(BatchDetectLanguageSentimentsRequest request) {
        LOG.trace("Called batchDetectLanguageSentiments");
        BatchDetectLanguageSentimentsRequest interceptedRequest = BatchDetectLanguageSentimentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageSentimentsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageSentiments", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageSentiments/BatchDetectLanguageSentiments");
        Function<Response, BatchDetectLanguageSentimentsResponse> transformer = BatchDetectLanguageSentimentsConverter.fromResponse(Optional.of(serviceDetails));
        return (BatchDetectLanguageSentimentsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchDetectLanguageSentimentsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBatchDetectLanguageSentimentsDetails(), (BmcRequest)retriedRequest);
                return (BatchDetectLanguageSentimentsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public BatchDetectLanguageTextClassificationResponse batchDetectLanguageTextClassification(BatchDetectLanguageTextClassificationRequest request) {
        LOG.trace("Called batchDetectLanguageTextClassification");
        BatchDetectLanguageTextClassificationRequest interceptedRequest = BatchDetectLanguageTextClassificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageTextClassificationConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageTextClassification", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageTextClassification/BatchDetectLanguageTextClassification");
        Function<Response, BatchDetectLanguageTextClassificationResponse> transformer = BatchDetectLanguageTextClassificationConverter.fromResponse(Optional.of(serviceDetails));
        return (BatchDetectLanguageTextClassificationResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchDetectLanguageTextClassificationResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBatchDetectLanguageTextClassificationDetails(), (BmcRequest)retriedRequest);
                return (BatchDetectLanguageTextClassificationResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public BatchLanguageTranslationResponse batchLanguageTranslation(BatchLanguageTranslationRequest request) {
        LOG.trace("Called batchLanguageTranslation");
        BatchLanguageTranslationRequest interceptedRequest = BatchLanguageTranslationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchLanguageTranslationConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchLanguageTranslation", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchLanguageTranslation/BatchLanguageTranslation");
        Function<Response, BatchLanguageTranslationResponse> transformer = BatchLanguageTranslationConverter.fromResponse(Optional.of(serviceDetails));
        return (BatchLanguageTranslationResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BatchLanguageTranslationResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBatchLanguageTranslationDetails(), (BmcRequest)retriedRequest);
                return (BatchLanguageTranslationResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeEndpointCompartmentResponse changeEndpointCompartment(ChangeEndpointCompartmentRequest request) {
        LOG.trace("Called changeEndpointCompartment");
        ChangeEndpointCompartmentRequest interceptedRequest = ChangeEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ChangeEndpointCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/ChangeEndpointCompartment");
        Function<Response, ChangeEndpointCompartmentResponse> transformer = ChangeEndpointCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        return (ChangeEndpointCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeEndpointCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeEndpointCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeEndpointCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeModelCompartmentResponse changeModelCompartment(ChangeModelCompartmentRequest request) {
        LOG.trace("Called changeModelCompartment");
        ChangeModelCompartmentRequest interceptedRequest = ChangeModelCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ChangeModelCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/ChangeModelCompartment");
        Function<Response, ChangeModelCompartmentResponse> transformer = ChangeModelCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        return (ChangeModelCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeModelCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeModelCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeModelCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        LOG.trace("Called changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ChangeProjectCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/ChangeProjectCompartment");
        Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        return (ChangeProjectCompartmentResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeProjectCompartmentResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeProjectCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeProjectCompartmentResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateEndpointResponse createEndpoint(CreateEndpointRequest request) {
        LOG.trace("Called createEndpoint");
        CreateEndpointRequest interceptedRequest = CreateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEndpointConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "CreateEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/CreateEndpoint");
        Function<Response, CreateEndpointResponse> transformer = CreateEndpointConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateEndpointResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateEndpointResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateEndpointDetails(), (BmcRequest)retriedRequest);
                return (CreateEndpointResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateModelResponse createModel(CreateModelRequest request) {
        LOG.trace("Called createModel");
        CreateModelRequest interceptedRequest = CreateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "CreateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/CreateModel");
        Function<Response, CreateModelResponse> transformer = CreateModelConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateModelDetails(), (BmcRequest)retriedRequest);
                return (CreateModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        LOG.trace("Called createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "CreateProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/CreateProject");
        Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse(Optional.of(serviceDetails));
        return (CreateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateProjectDetails(), (BmcRequest)retriedRequest);
                return (CreateProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteEndpointResponse deleteEndpoint(DeleteEndpointRequest request) {
        LOG.trace("Called deleteEndpoint");
        DeleteEndpointRequest interceptedRequest = DeleteEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEndpointConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DeleteEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/DeleteEndpoint");
        Function<Response, DeleteEndpointResponse> transformer = DeleteEndpointConverter.fromResponse(Optional.of(serviceDetails));
        return (DeleteEndpointResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteEndpointResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteEndpointResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteModelResponse deleteModel(DeleteModelRequest request) {
        LOG.trace("Called deleteModel");
        DeleteModelRequest interceptedRequest = DeleteModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DeleteModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/DeleteModel");
        Function<Response, DeleteModelResponse> transformer = DeleteModelConverter.fromResponse(Optional.of(serviceDetails));
        return (DeleteModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        LOG.trace("Called deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DeleteProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/DeleteProject");
        Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse(Optional.of(serviceDetails));
        return (DeleteProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DetectDominantLanguageResponse detectDominantLanguage(DetectDominantLanguageRequest request) {
        LOG.trace("Called detectDominantLanguage");
        DetectDominantLanguageRequest interceptedRequest = DetectDominantLanguageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectDominantLanguageConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectDominantLanguage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectDominantLanguage/DetectDominantLanguage");
        Function<Response, DetectDominantLanguageResponse> transformer = DetectDominantLanguageConverter.fromResponse(Optional.of(serviceDetails));
        return (DetectDominantLanguageResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetectDominantLanguageResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetectDominantLanguageDetails(), (BmcRequest)retriedRequest);
                return (DetectDominantLanguageResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DetectLanguageEntitiesResponse detectLanguageEntities(DetectLanguageEntitiesRequest request) {
        LOG.trace("Called detectLanguageEntities");
        DetectLanguageEntitiesRequest interceptedRequest = DetectLanguageEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageEntitiesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageEntities/DetectLanguageEntities");
        Function<Response, DetectLanguageEntitiesResponse> transformer = DetectLanguageEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        return (DetectLanguageEntitiesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetectLanguageEntitiesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetectLanguageEntitiesDetails(), (BmcRequest)retriedRequest);
                return (DetectLanguageEntitiesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DetectLanguageKeyPhrasesResponse detectLanguageKeyPhrases(DetectLanguageKeyPhrasesRequest request) {
        LOG.trace("Called detectLanguageKeyPhrases");
        DetectLanguageKeyPhrasesRequest interceptedRequest = DetectLanguageKeyPhrasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageKeyPhrasesConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageKeyPhrases", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageKeyPhrases/DetectLanguageKeyPhrases");
        Function<Response, DetectLanguageKeyPhrasesResponse> transformer = DetectLanguageKeyPhrasesConverter.fromResponse(Optional.of(serviceDetails));
        return (DetectLanguageKeyPhrasesResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetectLanguageKeyPhrasesResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetectLanguageKeyPhrasesDetails(), (BmcRequest)retriedRequest);
                return (DetectLanguageKeyPhrasesResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DetectLanguageSentimentsResponse detectLanguageSentiments(DetectLanguageSentimentsRequest request) {
        LOG.trace("Called detectLanguageSentiments");
        DetectLanguageSentimentsRequest interceptedRequest = DetectLanguageSentimentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageSentimentsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageSentiments", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageSentiments/DetectLanguageSentiments");
        Function<Response, DetectLanguageSentimentsResponse> transformer = DetectLanguageSentimentsConverter.fromResponse(Optional.of(serviceDetails));
        return (DetectLanguageSentimentsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetectLanguageSentimentsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetectLanguageSentimentsDetails(), (BmcRequest)retriedRequest);
                return (DetectLanguageSentimentsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public DetectLanguageTextClassificationResponse detectLanguageTextClassification(DetectLanguageTextClassificationRequest request) {
        LOG.trace("Called detectLanguageTextClassification");
        DetectLanguageTextClassificationRequest interceptedRequest = DetectLanguageTextClassificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageTextClassificationConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)false);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageTextClassification", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageTextClassification/DetectLanguageTextClassification");
        Function<Response, DetectLanguageTextClassificationResponse> transformer = DetectLanguageTextClassificationConverter.fromResponse(Optional.of(serviceDetails));
        return (DetectLanguageTextClassificationResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DetectLanguageTextClassificationResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getDetectLanguageTextClassificationDetails(), (BmcRequest)retriedRequest);
                return (DetectLanguageTextClassificationResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetEndpointResponse getEndpoint(GetEndpointRequest request) {
        LOG.trace("Called getEndpoint");
        GetEndpointRequest interceptedRequest = GetEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEndpointConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/GetEndpoint");
        Function<Response, GetEndpointResponse> transformer = GetEndpointConverter.fromResponse(Optional.of(serviceDetails));
        return (GetEndpointResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetEndpointResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetEndpointResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetModelResponse getModel(GetModelRequest request) {
        LOG.trace("Called getModel");
        GetModelRequest interceptedRequest = GetModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/GetModel");
        Function<Response, GetModelResponse> transformer = GetModelConverter.fromResponse(Optional.of(serviceDetails));
        return (GetModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        LOG.trace("Called getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/GetProject");
        Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse(Optional.of(serviceDetails));
        return (GetProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetWorkRequest", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequest/GetWorkRequest");
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse(Optional.of(serviceDetails));
        return (GetWorkRequestResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListEndpointsResponse listEndpoints(ListEndpointsRequest request) {
        LOG.trace("Called listEndpoints");
        ListEndpointsRequest interceptedRequest = ListEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEndpointsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListEndpoints", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/ListEndpoints");
        Function<Response, ListEndpointsResponse> transformer = ListEndpointsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListEndpointsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEndpointsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEndpointsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListEvaluationResultsResponse listEvaluationResults(ListEvaluationResultsRequest request) {
        LOG.trace("Called listEvaluationResults");
        ListEvaluationResultsRequest interceptedRequest = ListEvaluationResultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEvaluationResultsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListEvaluationResults", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/EvaluationResultCollection/ListEvaluationResults");
        Function<Response, ListEvaluationResultsResponse> transformer = ListEvaluationResultsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListEvaluationResultsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListEvaluationResultsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListEvaluationResultsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListModelsResponse listModels(ListModelsRequest request) {
        LOG.trace("Called listModels");
        ListModelsRequest interceptedRequest = ListModelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListModels", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/ListModels");
        Function<Response, ListModelsResponse> transformer = ListModelsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListModelsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListModelsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListModelsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        LOG.trace("Called listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListProjects", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/ListProjects");
        Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListProjectsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListProjectsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListProjectsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListWorkRequestErrors", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequestError/ListWorkRequestErrors");
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListWorkRequestErrorsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListWorkRequestLogs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequestLog/ListWorkRequestLogs");
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListWorkRequestLogsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListWorkRequests", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequest/ListWorkRequests");
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse(Optional.of(serviceDetails));
        return (ListWorkRequestsResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateEndpointResponse updateEndpoint(UpdateEndpointRequest request) {
        LOG.trace("Called updateEndpoint");
        UpdateEndpointRequest interceptedRequest = UpdateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEndpointConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "UpdateEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/UpdateEndpoint");
        Function<Response, UpdateEndpointResponse> transformer = UpdateEndpointConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateEndpointResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateEndpointResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateEndpointDetails(), (BmcRequest)retriedRequest);
                return (UpdateEndpointResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateModelResponse updateModel(UpdateModelRequest request) {
        LOG.trace("Called updateModel");
        UpdateModelRequest interceptedRequest = UpdateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "UpdateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/UpdateModel");
        Function<Response, UpdateModelResponse> transformer = UpdateModelConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateModelResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateModelResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateModelDetails(), (BmcRequest)retriedRequest);
                return (UpdateModelResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        LOG.trace("Called updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration, (boolean)true);
        RetryUtils.setClientRetriesHeader((WrappedInvocationBuilder)ib, (BmcGenericRetrier)retrier);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "UpdateProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/UpdateProject");
        Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse(Optional.of(serviceDetails));
        return (UpdateProjectResponse)((Object)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateProjectResponse)((Object)((Object)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateProjectDetails(), (BmcRequest)retriedRequest);
                return (UpdateProjectResponse)((Object)((Object)((Object)transformer.apply(response))));
            })));
        }));
    }

    @Override
    public AIServiceLanguageWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public AIServiceLanguagePaginators getPaginators() {
        return this.paginators;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceLanguageClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public AIServiceLanguageClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new AIServiceLanguageClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

