/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.ailanguage.model.BatchLanguageTranslationResult;
import com.oracle.bmc.ailanguage.requests.BatchLanguageTranslationRequest;
import com.oracle.bmc.ailanguage.responses.BatchLanguageTranslationResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchLanguageTranslationConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(BatchLanguageTranslationConverter.class);

    public static BatchLanguageTranslationRequest interceptRequest(BatchLanguageTranslationRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, BatchLanguageTranslationRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getBatchLanguageTranslationDetails()), (String)"batchLanguageTranslationDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20221001").path("actions").path("batchLanguageTranslation");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, BatchLanguageTranslationResponse> fromResponse() {
        return BatchLanguageTranslationConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, BatchLanguageTranslationResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, BatchLanguageTranslationResponse> transformer = new Function<Response, BatchLanguageTranslationResponse>(){

            @Override
            public BatchLanguageTranslationResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.ailanguage.responses.BatchLanguageTranslationResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(BatchLanguageTranslationResult.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(BatchLanguageTranslationResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                BatchLanguageTranslationResponse.Builder builder = BatchLanguageTranslationResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.batchLanguageTranslationResult((BatchLanguageTranslationResult)((Object)response.getItem()));
                Optional opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                BatchLanguageTranslationResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

