/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.ailanguage.model.TextDocument;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BatchDetectLanguageTextClassificationDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="endpointId")
    private final String endpointId;
    @JsonProperty(value="documents")
    private final List<TextDocument> documents;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "endpointId", "documents"})
    public BatchDetectLanguageTextClassificationDetails(String compartmentId, String endpointId, List<TextDocument> documents) {
        this.compartmentId = compartmentId;
        this.endpointId = endpointId;
        this.documents = documents;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public List<TextDocument> getDocuments() {
        return this.documents;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BatchDetectLanguageTextClassificationDetails(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", endpointId=").append(String.valueOf(this.endpointId));
        sb.append(", documents=").append(String.valueOf(this.documents));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchDetectLanguageTextClassificationDetails)) {
            return false;
        }
        BatchDetectLanguageTextClassificationDetails other = (BatchDetectLanguageTextClassificationDetails)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.endpointId, other.endpointId) && Objects.equals(this.documents, other.documents) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.endpointId == null ? 43 : this.endpointId.hashCode());
        result = result * 59 + (this.documents == null ? 43 : this.documents.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="endpointId")
        private String endpointId;
        @JsonProperty(value="documents")
        private List<TextDocument> documents;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            this.__explicitlySet__.add("endpointId");
            return this;
        }

        public Builder documents(List<TextDocument> documents) {
            this.documents = documents;
            this.__explicitlySet__.add("documents");
            return this;
        }

        public BatchDetectLanguageTextClassificationDetails build() {
            BatchDetectLanguageTextClassificationDetails model = new BatchDetectLanguageTextClassificationDetails(this.compartmentId, this.endpointId, this.documents);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BatchDetectLanguageTextClassificationDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("endpointId")) {
                this.endpointId(model.getEndpointId());
            }
            if (model.wasPropertyExplicitlySet("documents")) {
                this.documents(model.getDocuments());
            }
            return this;
        }
    }
}

