/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class EntityMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="f1")
    private final Float f1;
    @JsonProperty(value="precision")
    private final Float precision;
    @JsonProperty(value="recall")
    private final Float recall;

    @Deprecated
    @ConstructorProperties(value={"label", "f1", "precision", "recall"})
    public EntityMetrics(String label, Float f1, Float precision, Float recall) {
        this.label = label;
        this.f1 = f1;
        this.precision = precision;
        this.recall = recall;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getLabel() {
        return this.label;
    }

    public Float getF1() {
        return this.f1;
    }

    public Float getPrecision() {
        return this.precision;
    }

    public Float getRecall() {
        return this.recall;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("label=").append(String.valueOf(this.label));
        sb.append(", f1=").append(String.valueOf(this.f1));
        sb.append(", precision=").append(String.valueOf(this.precision));
        sb.append(", recall=").append(String.valueOf(this.recall));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityMetrics)) {
            return false;
        }
        EntityMetrics other = (EntityMetrics)((Object)o);
        return Objects.equals(this.label, other.label) && Objects.equals(this.f1, other.f1) && Objects.equals(this.precision, other.precision) && Objects.equals(this.recall, other.recall) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.f1 == null ? 43 : this.f1.hashCode());
        result = result * 59 + (this.precision == null ? 43 : this.precision.hashCode());
        result = result * 59 + (this.recall == null ? 43 : this.recall.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="f1")
        private Float f1;
        @JsonProperty(value="precision")
        private Float precision;
        @JsonProperty(value="recall")
        private Float recall;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder f1(Float f1) {
            this.f1 = f1;
            this.__explicitlySet__.add("f1");
            return this;
        }

        public Builder precision(Float precision) {
            this.precision = precision;
            this.__explicitlySet__.add("precision");
            return this;
        }

        public Builder recall(Float recall) {
            this.recall = recall;
            this.__explicitlySet__.add("recall");
            return this;
        }

        public EntityMetrics build() {
            EntityMetrics model = new EntityMetrics(this.label, this.f1, this.precision, this.recall);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(EntityMetrics model) {
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("f1")) {
                this.f1(model.getF1());
            }
            if (model.wasPropertyExplicitlySet("precision")) {
                this.precision(model.getPrecision());
            }
            if (model.wasPropertyExplicitlySet("recall")) {
                this.recall(model.getRecall());
            }
            return this;
        }
    }
}

