/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.Services;
import com.oracle.bmc.ailanguage.AIServiceLanguageAsync;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectDominantLanguageConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageKeyPhrasesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguagePiiEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageSentimentsConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchDetectLanguageTextClassificationConverter;
import com.oracle.bmc.ailanguage.internal.http.BatchLanguageTranslationConverter;
import com.oracle.bmc.ailanguage.internal.http.ChangeEndpointCompartmentConverter;
import com.oracle.bmc.ailanguage.internal.http.ChangeModelCompartmentConverter;
import com.oracle.bmc.ailanguage.internal.http.ChangeProjectCompartmentConverter;
import com.oracle.bmc.ailanguage.internal.http.CreateEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.CreateModelConverter;
import com.oracle.bmc.ailanguage.internal.http.CreateProjectConverter;
import com.oracle.bmc.ailanguage.internal.http.DeleteEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.DeleteModelConverter;
import com.oracle.bmc.ailanguage.internal.http.DeleteProjectConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectDominantLanguageConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageEntitiesConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageKeyPhrasesConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageSentimentsConverter;
import com.oracle.bmc.ailanguage.internal.http.DetectLanguageTextClassificationConverter;
import com.oracle.bmc.ailanguage.internal.http.GetEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.GetModelConverter;
import com.oracle.bmc.ailanguage.internal.http.GetProjectConverter;
import com.oracle.bmc.ailanguage.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.ailanguage.internal.http.ListEndpointsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListEvaluationResultsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListModelsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListProjectsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.ailanguage.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.ailanguage.internal.http.UpdateEndpointConverter;
import com.oracle.bmc.ailanguage.internal.http.UpdateModelConverter;
import com.oracle.bmc.ailanguage.internal.http.UpdateProjectConverter;
import com.oracle.bmc.ailanguage.requests.BatchDetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguagePiiEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.BatchDetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.requests.BatchLanguageTranslationRequest;
import com.oracle.bmc.ailanguage.requests.ChangeEndpointCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.ChangeModelCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.ailanguage.requests.CreateEndpointRequest;
import com.oracle.bmc.ailanguage.requests.CreateModelRequest;
import com.oracle.bmc.ailanguage.requests.CreateProjectRequest;
import com.oracle.bmc.ailanguage.requests.DeleteEndpointRequest;
import com.oracle.bmc.ailanguage.requests.DeleteModelRequest;
import com.oracle.bmc.ailanguage.requests.DeleteProjectRequest;
import com.oracle.bmc.ailanguage.requests.DetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageEntitiesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageKeyPhrasesRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageSentimentsRequest;
import com.oracle.bmc.ailanguage.requests.DetectLanguageTextClassificationRequest;
import com.oracle.bmc.ailanguage.requests.GetEndpointRequest;
import com.oracle.bmc.ailanguage.requests.GetModelRequest;
import com.oracle.bmc.ailanguage.requests.GetProjectRequest;
import com.oracle.bmc.ailanguage.requests.GetWorkRequestRequest;
import com.oracle.bmc.ailanguage.requests.ListEndpointsRequest;
import com.oracle.bmc.ailanguage.requests.ListEvaluationResultsRequest;
import com.oracle.bmc.ailanguage.requests.ListModelsRequest;
import com.oracle.bmc.ailanguage.requests.ListProjectsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.ailanguage.requests.ListWorkRequestsRequest;
import com.oracle.bmc.ailanguage.requests.UpdateEndpointRequest;
import com.oracle.bmc.ailanguage.requests.UpdateModelRequest;
import com.oracle.bmc.ailanguage.requests.UpdateProjectRequest;
import com.oracle.bmc.ailanguage.responses.BatchDetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguagePiiEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.BatchDetectLanguageTextClassificationResponse;
import com.oracle.bmc.ailanguage.responses.BatchLanguageTranslationResponse;
import com.oracle.bmc.ailanguage.responses.ChangeEndpointCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.ChangeModelCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.ailanguage.responses.CreateEndpointResponse;
import com.oracle.bmc.ailanguage.responses.CreateModelResponse;
import com.oracle.bmc.ailanguage.responses.CreateProjectResponse;
import com.oracle.bmc.ailanguage.responses.DeleteEndpointResponse;
import com.oracle.bmc.ailanguage.responses.DeleteModelResponse;
import com.oracle.bmc.ailanguage.responses.DeleteProjectResponse;
import com.oracle.bmc.ailanguage.responses.DetectDominantLanguageResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageEntitiesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageKeyPhrasesResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageSentimentsResponse;
import com.oracle.bmc.ailanguage.responses.DetectLanguageTextClassificationResponse;
import com.oracle.bmc.ailanguage.responses.GetEndpointResponse;
import com.oracle.bmc.ailanguage.responses.GetModelResponse;
import com.oracle.bmc.ailanguage.responses.GetProjectResponse;
import com.oracle.bmc.ailanguage.responses.GetWorkRequestResponse;
import com.oracle.bmc.ailanguage.responses.ListEndpointsResponse;
import com.oracle.bmc.ailanguage.responses.ListEvaluationResultsResponse;
import com.oracle.bmc.ailanguage.responses.ListModelsResponse;
import com.oracle.bmc.ailanguage.responses.ListProjectsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.ailanguage.responses.ListWorkRequestsResponse;
import com.oracle.bmc.ailanguage.responses.UpdateEndpointResponse;
import com.oracle.bmc.ailanguage.responses.UpdateModelResponse;
import com.oracle.bmc.ailanguage.responses.UpdateProjectResponse;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ApacheUtils;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.GuavaUtils;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.RealmSpecificEndpointTemplateUtils;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIServiceLanguageAsyncClient
implements AIServiceLanguageAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("AISERVICELANGUAGE").serviceEndpointPrefix("").serviceEndpointTemplate("https://language.aiservice.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(AIServiceLanguageAsyncClient.class);
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ApacheConnectionClosingStrategy apacheConnectionClosingStrategy;
    private final RestClientFactory restClientFactory;
    private final RequestSignerFactory defaultRequestSignerFactory;
    private final Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories;
    private final boolean isNonBufferingApacheClient;
    private final ClientConfiguration clientConfigurationToUse;
    private String regionId;
    private final Object clientUpdate = new Object();
    private volatile RestClient client;
    private volatile String overrideEndpoint = null;

    public AIServiceLanguageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public AIServiceLanguageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public AIServiceLanguageAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public AIServiceLanguageAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        this.restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        this.isNonBufferingApacheClient = ApacheUtils.isNonBufferingClientConfigurator((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.apacheConnectionClosingStrategy = ApacheUtils.getApacheConnectionClosingStrategy((ClientConfigurator)this.restClientFactory.getClientConfigurator());
        this.defaultRequestSignerFactory = defaultRequestSignerFactory;
        this.signingStrategyRequestSignerFactories = signingStrategyRequestSignerFactories;
        this.clientConfigurationToUse = configuration;
        this.refreshClient();
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.regionId = provider.getRegion().getRegionId();
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    RestClient getClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshClient() {
        LOG.info("Refreshing client '{}'.", this.client != null ? this.client.getClass() : null);
        RequestSigner defaultRequestSigner = this.defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, this.signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, this.authenticationDetailsProvider));
            }
        }
        RestClient refreshedClient = this.restClientFactory.create(defaultRequestSigner, requestSigners, this.clientConfigurationToUse, this.isNonBufferingApacheClient);
        Object object = this.clientUpdate;
        synchronized (object) {
            if (this.overrideEndpoint != null) {
                refreshedClient.setEndpoint(this.overrideEndpoint);
            }
            this.client = refreshedClient;
        }
        LOG.info("Refreshed client '{}'.", this.client != null ? this.client.getClass() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        Object object = this.clientUpdate;
        synchronized (object) {
            this.overrideEndpoint = endpoint;
            this.client.setEndpoint(endpoint);
        }
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        this.regionId = region.getRegionId();
        Optional endpoint = GuavaUtils.adaptFromGuava((com.google.common.base.Optional)region.getEndpoint(SERVICE));
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        this.regionId = regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public synchronized void useRealmSpecificEndpointTemplate(boolean useOfRealmSpecificEndpointTemplateEnabled) {
        this.setEndpoint(RealmSpecificEndpointTemplateUtils.getRealmSpecificEndpointTemplate((boolean)useOfRealmSpecificEndpointTemplateEnabled, (String)this.regionId, (Service)SERVICE));
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<BatchDetectDominantLanguageResponse> batchDetectDominantLanguage(BatchDetectDominantLanguageRequest request, AsyncHandler<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse> handler) {
        LOG.trace("Called async batchDetectDominantLanguage");
        BatchDetectDominantLanguageRequest interceptedRequest = BatchDetectDominantLanguageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectDominantLanguageConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectDominantLanguage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectDominantLanguage/BatchDetectDominantLanguage");
        Function<Response, BatchDetectDominantLanguageResponse> transformer = BatchDetectDominantLanguageConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectDominantLanguageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectDominantLanguageRequest, BatchDetectDominantLanguageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageEntitiesResponse> batchDetectLanguageEntities(BatchDetectLanguageEntitiesRequest request, AsyncHandler<BatchDetectLanguageEntitiesRequest, BatchDetectLanguageEntitiesResponse> handler) {
        LOG.trace("Called async batchDetectLanguageEntities");
        BatchDetectLanguageEntitiesRequest interceptedRequest = BatchDetectLanguageEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageEntitiesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageEntities/BatchDetectLanguageEntities");
        Function<Response, BatchDetectLanguageEntitiesResponse> transformer = BatchDetectLanguageEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageEntitiesRequest, BatchDetectLanguageEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageEntitiesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageEntitiesRequest, BatchDetectLanguageEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageKeyPhrasesResponse> batchDetectLanguageKeyPhrases(BatchDetectLanguageKeyPhrasesRequest request, AsyncHandler<BatchDetectLanguageKeyPhrasesRequest, BatchDetectLanguageKeyPhrasesResponse> handler) {
        LOG.trace("Called async batchDetectLanguageKeyPhrases");
        BatchDetectLanguageKeyPhrasesRequest interceptedRequest = BatchDetectLanguageKeyPhrasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageKeyPhrasesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageKeyPhrases", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageKeyPhrases/BatchDetectLanguageKeyPhrases");
        Function<Response, BatchDetectLanguageKeyPhrasesResponse> transformer = BatchDetectLanguageKeyPhrasesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageKeyPhrasesRequest, BatchDetectLanguageKeyPhrasesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageKeyPhrasesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageKeyPhrasesRequest, BatchDetectLanguageKeyPhrasesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguagePiiEntitiesResponse> batchDetectLanguagePiiEntities(BatchDetectLanguagePiiEntitiesRequest request, AsyncHandler<BatchDetectLanguagePiiEntitiesRequest, BatchDetectLanguagePiiEntitiesResponse> handler) {
        LOG.trace("Called async batchDetectLanguagePiiEntities");
        BatchDetectLanguagePiiEntitiesRequest interceptedRequest = BatchDetectLanguagePiiEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguagePiiEntitiesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguagePiiEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguagePiiEntities/BatchDetectLanguagePiiEntities");
        Function<Response, BatchDetectLanguagePiiEntitiesResponse> transformer = BatchDetectLanguagePiiEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguagePiiEntitiesRequest, BatchDetectLanguagePiiEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguagePiiEntitiesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguagePiiEntitiesRequest, BatchDetectLanguagePiiEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageSentimentsResponse> batchDetectLanguageSentiments(BatchDetectLanguageSentimentsRequest request, AsyncHandler<BatchDetectLanguageSentimentsRequest, BatchDetectLanguageSentimentsResponse> handler) {
        LOG.trace("Called async batchDetectLanguageSentiments");
        BatchDetectLanguageSentimentsRequest interceptedRequest = BatchDetectLanguageSentimentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageSentimentsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageSentiments", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageSentiments/BatchDetectLanguageSentiments");
        Function<Response, BatchDetectLanguageSentimentsResponse> transformer = BatchDetectLanguageSentimentsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageSentimentsRequest, BatchDetectLanguageSentimentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageSentimentsDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageSentimentsRequest, BatchDetectLanguageSentimentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchDetectLanguageTextClassificationResponse> batchDetectLanguageTextClassification(BatchDetectLanguageTextClassificationRequest request, AsyncHandler<BatchDetectLanguageTextClassificationRequest, BatchDetectLanguageTextClassificationResponse> handler) {
        LOG.trace("Called async batchDetectLanguageTextClassification");
        BatchDetectLanguageTextClassificationRequest interceptedRequest = BatchDetectLanguageTextClassificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchDetectLanguageTextClassificationConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchDetectLanguageTextClassification", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchDetectLanguageTextClassification/BatchDetectLanguageTextClassification");
        Function<Response, BatchDetectLanguageTextClassificationResponse> transformer = BatchDetectLanguageTextClassificationConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchDetectLanguageTextClassificationRequest, BatchDetectLanguageTextClassificationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchDetectLanguageTextClassificationDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchDetectLanguageTextClassificationRequest, BatchDetectLanguageTextClassificationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<BatchLanguageTranslationResponse> batchLanguageTranslation(BatchLanguageTranslationRequest request, AsyncHandler<BatchLanguageTranslationRequest, BatchLanguageTranslationResponse> handler) {
        LOG.trace("Called async batchLanguageTranslation");
        BatchLanguageTranslationRequest interceptedRequest = BatchLanguageTranslationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BatchLanguageTranslationConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "BatchLanguageTranslation", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/BatchLanguageTranslation/BatchLanguageTranslation");
        Function<Response, BatchLanguageTranslationResponse> transformer = BatchLanguageTranslationConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<BatchLanguageTranslationRequest, BatchLanguageTranslationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getBatchLanguageTranslationDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BatchLanguageTranslationRequest, BatchLanguageTranslationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeEndpointCompartmentResponse> changeEndpointCompartment(ChangeEndpointCompartmentRequest request, AsyncHandler<ChangeEndpointCompartmentRequest, ChangeEndpointCompartmentResponse> handler) {
        LOG.trace("Called async changeEndpointCompartment");
        ChangeEndpointCompartmentRequest interceptedRequest = ChangeEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ChangeEndpointCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/ChangeEndpointCompartment");
        Function<Response, ChangeEndpointCompartmentResponse> transformer = ChangeEndpointCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ChangeEndpointCompartmentRequest, ChangeEndpointCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeEndpointCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeEndpointCompartmentRequest, ChangeEndpointCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeModelCompartmentResponse> changeModelCompartment(ChangeModelCompartmentRequest request, AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handler) {
        LOG.trace("Called async changeModelCompartment");
        ChangeModelCompartmentRequest interceptedRequest = ChangeModelCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeModelCompartmentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ChangeModelCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/ChangeModelCompartment");
        Function<Response, ChangeModelCompartmentResponse> transformer = ChangeModelCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeModelCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeModelCompartmentRequest, ChangeModelCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeProjectCompartmentResponse> changeProjectCompartment(ChangeProjectCompartmentRequest request, AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handler) {
        LOG.trace("Called async changeProjectCompartment");
        ChangeProjectCompartmentRequest interceptedRequest = ChangeProjectCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeProjectCompartmentConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ChangeProjectCompartment", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/ChangeProjectCompartment");
        Function<Response, ChangeProjectCompartmentResponse> transformer = ChangeProjectCompartmentConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getChangeProjectCompartmentDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeProjectCompartmentRequest, ChangeProjectCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateEndpointResponse> createEndpoint(CreateEndpointRequest request, AsyncHandler<CreateEndpointRequest, CreateEndpointResponse> handler) {
        LOG.trace("Called async createEndpoint");
        CreateEndpointRequest interceptedRequest = CreateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateEndpointConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "CreateEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/CreateEndpoint");
        Function<Response, CreateEndpointResponse> transformer = CreateEndpointConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateEndpointRequest, CreateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateEndpointDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateEndpointRequest, CreateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateModelResponse> createModel(CreateModelRequest request, AsyncHandler<CreateModelRequest, CreateModelResponse> handler) {
        LOG.trace("Called async createModel");
        CreateModelRequest interceptedRequest = CreateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateModelConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "CreateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/CreateModel");
        Function<Response, CreateModelResponse> transformer = CreateModelConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateModelRequest, CreateModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateModelDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateModelRequest, CreateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateProjectResponse> createProject(CreateProjectRequest request, AsyncHandler<CreateProjectRequest, CreateProjectResponse> handler) {
        LOG.trace("Called async createProject");
        CreateProjectRequest interceptedRequest = CreateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateProjectConverter.fromRequest(this.client, interceptedRequest);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "CreateProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/CreateProject");
        Function<Response, CreateProjectResponse> transformer = CreateProjectConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<CreateProjectRequest, CreateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getCreateProjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateProjectRequest, CreateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteEndpointResponse> deleteEndpoint(DeleteEndpointRequest request, AsyncHandler<DeleteEndpointRequest, DeleteEndpointResponse> handler) {
        LOG.trace("Called async deleteEndpoint");
        DeleteEndpointRequest interceptedRequest = DeleteEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteEndpointConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DeleteEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/DeleteEndpoint");
        Function<Response, DeleteEndpointResponse> transformer = DeleteEndpointConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DeleteEndpointRequest, DeleteEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteEndpointRequest, DeleteEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteModelResponse> deleteModel(DeleteModelRequest request, AsyncHandler<DeleteModelRequest, DeleteModelResponse> handler) {
        LOG.trace("Called async deleteModel");
        DeleteModelRequest interceptedRequest = DeleteModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteModelConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DeleteModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/DeleteModel");
        Function<Response, DeleteModelResponse> transformer = DeleteModelConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DeleteModelRequest, DeleteModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteModelRequest, DeleteModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteProjectResponse> deleteProject(DeleteProjectRequest request, AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handler) {
        LOG.trace("Called async deleteProject");
        DeleteProjectRequest interceptedRequest = DeleteProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteProjectConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DeleteProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/DeleteProject");
        Function<Response, DeleteProjectResponse> transformer = DeleteProjectConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DeleteProjectRequest, DeleteProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteProjectRequest, DeleteProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectDominantLanguageResponse> detectDominantLanguage(DetectDominantLanguageRequest request, AsyncHandler<DetectDominantLanguageRequest, DetectDominantLanguageResponse> handler) {
        LOG.trace("Called async detectDominantLanguage");
        DetectDominantLanguageRequest interceptedRequest = DetectDominantLanguageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectDominantLanguageConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectDominantLanguage", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectDominantLanguage/DetectDominantLanguage");
        Function<Response, DetectDominantLanguageResponse> transformer = DetectDominantLanguageConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectDominantLanguageRequest, DetectDominantLanguageResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectDominantLanguageDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectDominantLanguageRequest, DetectDominantLanguageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageEntitiesResponse> detectLanguageEntities(DetectLanguageEntitiesRequest request, AsyncHandler<DetectLanguageEntitiesRequest, DetectLanguageEntitiesResponse> handler) {
        LOG.trace("Called async detectLanguageEntities");
        DetectLanguageEntitiesRequest interceptedRequest = DetectLanguageEntitiesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageEntitiesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageEntities", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageEntities/DetectLanguageEntities");
        Function<Response, DetectLanguageEntitiesResponse> transformer = DetectLanguageEntitiesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageEntitiesRequest, DetectLanguageEntitiesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageEntitiesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageEntitiesRequest, DetectLanguageEntitiesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageKeyPhrasesResponse> detectLanguageKeyPhrases(DetectLanguageKeyPhrasesRequest request, AsyncHandler<DetectLanguageKeyPhrasesRequest, DetectLanguageKeyPhrasesResponse> handler) {
        LOG.trace("Called async detectLanguageKeyPhrases");
        DetectLanguageKeyPhrasesRequest interceptedRequest = DetectLanguageKeyPhrasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageKeyPhrasesConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageKeyPhrases", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageKeyPhrases/DetectLanguageKeyPhrases");
        Function<Response, DetectLanguageKeyPhrasesResponse> transformer = DetectLanguageKeyPhrasesConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageKeyPhrasesRequest, DetectLanguageKeyPhrasesResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageKeyPhrasesDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageKeyPhrasesRequest, DetectLanguageKeyPhrasesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageSentimentsResponse> detectLanguageSentiments(DetectLanguageSentimentsRequest request, AsyncHandler<DetectLanguageSentimentsRequest, DetectLanguageSentimentsResponse> handler) {
        LOG.trace("Called async detectLanguageSentiments");
        DetectLanguageSentimentsRequest interceptedRequest = DetectLanguageSentimentsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageSentimentsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageSentiments", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageSentiments/DetectLanguageSentiments");
        Function<Response, DetectLanguageSentimentsResponse> transformer = DetectLanguageSentimentsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageSentimentsRequest, DetectLanguageSentimentsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageSentimentsDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageSentimentsRequest, DetectLanguageSentimentsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DetectLanguageTextClassificationResponse> detectLanguageTextClassification(DetectLanguageTextClassificationRequest request, AsyncHandler<DetectLanguageTextClassificationRequest, DetectLanguageTextClassificationResponse> handler) {
        LOG.trace("Called async detectLanguageTextClassification");
        DetectLanguageTextClassificationRequest interceptedRequest = DetectLanguageTextClassificationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DetectLanguageTextClassificationConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "DetectLanguageTextClassification", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/DetectLanguageTextClassification/DetectLanguageTextClassification");
        Function<Response, DetectLanguageTextClassificationResponse> transformer = DetectLanguageTextClassificationConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<DetectLanguageTextClassificationRequest, DetectLanguageTextClassificationResponse> handlerToUse = handler;
        Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getDetectLanguageTextClassificationDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DetectLanguageTextClassificationRequest, DetectLanguageTextClassificationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetEndpointResponse> getEndpoint(GetEndpointRequest request, AsyncHandler<GetEndpointRequest, GetEndpointResponse> handler) {
        LOG.trace("Called async getEndpoint");
        GetEndpointRequest interceptedRequest = GetEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetEndpointConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/GetEndpoint");
        Function<Response, GetEndpointResponse> transformer = GetEndpointConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetEndpointRequest, GetEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetEndpointRequest, GetEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetModelResponse> getModel(GetModelRequest request, AsyncHandler<GetModelRequest, GetModelResponse> handler) {
        LOG.trace("Called async getModel");
        GetModelRequest interceptedRequest = GetModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetModelConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/GetModel");
        Function<Response, GetModelResponse> transformer = GetModelConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetModelRequest, GetModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetModelRequest, GetModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetProjectResponse> getProject(GetProjectRequest request, AsyncHandler<GetProjectRequest, GetProjectResponse> handler) {
        LOG.trace("Called async getProject");
        GetProjectRequest interceptedRequest = GetProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetProjectConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/GetProject");
        Function<Response, GetProjectResponse> transformer = GetProjectConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetProjectRequest, GetProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetProjectRequest, GetProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "GetWorkRequest", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequest/GetWorkRequest");
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEndpointsResponse> listEndpoints(ListEndpointsRequest request, AsyncHandler<ListEndpointsRequest, ListEndpointsResponse> handler) {
        LOG.trace("Called async listEndpoints");
        ListEndpointsRequest interceptedRequest = ListEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEndpointsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListEndpoints", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/ListEndpoints");
        Function<Response, ListEndpointsResponse> transformer = ListEndpointsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListEndpointsRequest, ListEndpointsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEndpointsRequest, ListEndpointsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListEvaluationResultsResponse> listEvaluationResults(ListEvaluationResultsRequest request, AsyncHandler<ListEvaluationResultsRequest, ListEvaluationResultsResponse> handler) {
        LOG.trace("Called async listEvaluationResults");
        ListEvaluationResultsRequest interceptedRequest = ListEvaluationResultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListEvaluationResultsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListEvaluationResults", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/EvaluationResultCollection/ListEvaluationResults");
        Function<Response, ListEvaluationResultsResponse> transformer = ListEvaluationResultsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListEvaluationResultsRequest, ListEvaluationResultsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListEvaluationResultsRequest, ListEvaluationResultsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListModelsResponse> listModels(ListModelsRequest request, AsyncHandler<ListModelsRequest, ListModelsResponse> handler) {
        LOG.trace("Called async listModels");
        ListModelsRequest interceptedRequest = ListModelsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListModelsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListModels", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/ListModels");
        Function<Response, ListModelsResponse> transformer = ListModelsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListModelsRequest, ListModelsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListModelsRequest, ListModelsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListProjectsResponse> listProjects(ListProjectsRequest request, AsyncHandler<ListProjectsRequest, ListProjectsResponse> handler) {
        LOG.trace("Called async listProjects");
        ListProjectsRequest interceptedRequest = ListProjectsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListProjectsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListProjects", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/ListProjects");
        Function<Response, ListProjectsResponse> transformer = ListProjectsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListProjectsRequest, ListProjectsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListProjectsRequest, ListProjectsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListWorkRequestErrors", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequestError/ListWorkRequestErrors");
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListWorkRequestLogs", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequestLog/ListWorkRequestLogs");
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "ListWorkRequests", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/WorkRequest/ListWorkRequests");
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateEndpointResponse> updateEndpoint(UpdateEndpointRequest request, AsyncHandler<UpdateEndpointRequest, UpdateEndpointResponse> handler) {
        LOG.trace("Called async updateEndpoint");
        UpdateEndpointRequest interceptedRequest = UpdateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateEndpointConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "UpdateEndpoint", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Endpoint/UpdateEndpoint");
        Function<Response, UpdateEndpointResponse> transformer = UpdateEndpointConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateEndpointRequest, UpdateEndpointResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateEndpointDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateEndpointRequest, UpdateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateModelResponse> updateModel(UpdateModelRequest request, AsyncHandler<UpdateModelRequest, UpdateModelResponse> handler) {
        LOG.trace("Called async updateModel");
        UpdateModelRequest interceptedRequest = UpdateModelConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateModelConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "UpdateModel", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Model/UpdateModel");
        Function<Response, UpdateModelResponse> transformer = UpdateModelConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateModelRequest, UpdateModelResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateModelDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateModelRequest, UpdateModelResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateProjectResponse> updateProject(UpdateProjectRequest request, AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handler) {
        LOG.trace("Called async updateProject");
        UpdateProjectRequest interceptedRequest = UpdateProjectConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateProjectConverter.fromRequest(this.client, interceptedRequest);
        ServiceDetails serviceDetails = new ServiceDetails("AIServiceLanguage", "UpdateProject", ib.getRequestUri().toString(), "https://docs.oracle.com/iaas/api/#/en/language/20221001/Project/UpdateProject");
        Function<Response, UpdateProjectResponse> transformer = UpdateProjectConverter.fromResponse(Optional.of(serviceDetails));
        AsyncHandler<UpdateProjectRequest, UpdateProjectResponse> handlerToUse = handler;
        Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, (Object)interceptedRequest.getUpdateProjectDetails(), ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateProjectRequest, UpdateProjectResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, AIServiceLanguageAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public AIServiceLanguageAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new AIServiceLanguageAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

