/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.ailanguage.internal.http;

import com.oracle.bmc.ServiceDetails;
import com.oracle.bmc.ailanguage.model.BatchDetectDominantLanguageResult;
import com.oracle.bmc.ailanguage.requests.BatchDetectDominantLanguageRequest;
import com.oracle.bmc.ailanguage.responses.BatchDetectDominantLanguageResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactoryV2;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchDetectDominantLanguageConverter {
    private static final ResponseConversionFunctionFactoryV2 RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactoryV2();
    private static final Logger LOG = LoggerFactory.getLogger(BatchDetectDominantLanguageConverter.class);

    public static BatchDetectDominantLanguageRequest interceptRequest(BatchDetectDominantLanguageRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, BatchDetectDominantLanguageRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)request.getBatchDetectDominantLanguageDetails()), (String)"batchDetectDominantLanguageDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20221001").path("actions").path("batchDetectDominantLanguage");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (client.getClientConfigurator() != null) {
            client.getClientConfigurator().customizeRequest((BmcRequest)request, ib);
        }
        return ib;
    }

    public static Function<Response, BatchDetectDominantLanguageResponse> fromResponse() {
        return BatchDetectDominantLanguageConverter.fromResponse(Optional.empty());
    }

    public static Function<Response, BatchDetectDominantLanguageResponse> fromResponse(final Optional<ServiceDetails> serviceDetails) {
        Function<Response, BatchDetectDominantLanguageResponse> transformer = new Function<Response, BatchDetectDominantLanguageResponse>(){

            @Override
            public BatchDetectDominantLanguageResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.ailanguage.responses.BatchDetectDominantLanguageResponse");
                Function responseFn = serviceDetails.isPresent() ? RESPONSE_CONVERSION_FACTORY.create(BatchDetectDominantLanguageResult.class, (ServiceDetails)serviceDetails.get()) : RESPONSE_CONVERSION_FACTORY.create(BatchDetectDominantLanguageResult.class);
                WithHeaders response = (WithHeaders)responseFn.apply(rawResponse);
                MultivaluedMap headers = response.getHeaders();
                BatchDetectDominantLanguageResponse.Builder builder = BatchDetectDominantLanguageResponse.builder().__httpStatusCode__(rawResponse.getStatus()).headers((MultivaluedMap<String, String>)headers);
                builder.batchDetectDominantLanguageResult((BatchDetectDominantLanguageResult)((Object)response.getItem()));
                Optional opcRequestIdHeader = HeaderUtils.getHeadersWithName((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                BatchDetectDominantLanguageResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

